/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.ppr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.context.RequestContextImpl;

public class PartialPageContextImpl
extends PartialPageContext {
    private static final Set<VisitHint> _PPR_VISIT_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_UNRENDERED, VisitHint.EXECUTE_LIFECYCLE));
    private final FacesContext _context;
    private final Map<String, Boolean> _targets = new HashMap<String, Boolean>();
    private final Set<String> _renderedTargets = new HashSet<String>();
    private final Set<String> _targetIds = new HashSet<String>();
    private final Set<String> _unmodifiableTargets;
    private final Map<String, Collection<String>> _subtreeClientIds = new HashMap<String, Collection<String>>();
    private final Stack<String> _currentTargetStack = new Stack();
    private final VisitContext _visitContext = new PartialPageVisitContext();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PartialPageContextImpl.class);

    public PartialPageContextImpl(FacesContext context, RequestContext reqContext) {
        FacesContext facesContext = this._context = context != null ? context : FacesContext.getCurrentInstance();
        if (reqContext instanceof RequestContextImpl) {
            RequestContextImpl requestContext = (RequestContextImpl)reqContext;
            Iterator<String> targetIter = requestContext.getPartialTargets();
            while (targetIter.hasNext()) {
                this.addPartialTarget(targetIter.next());
            }
        }
        if (this._targets.isEmpty()) {
            _LOG.fine("PPR is about to render without any targets");
        }
        this._unmodifiableTargets = Collections.unmodifiableSet(this._targets.keySet());
    }

    public Iterator<String> getPartialTargets() {
        return this._targets.keySet().iterator();
    }

    public boolean isPartialTarget(String clientId) {
        return clientId != null && this._targets.containsKey(clientId);
    }

    public boolean isPossiblePartialTarget(String componentId) {
        return componentId != null && this._targetIds.contains(componentId);
    }

    public boolean isPartialTargetRendered(String id) {
        return this._renderedTargets.contains(id);
    }

    public boolean areAllTargetsProcessed() {
        return this._renderedTargets.size() == this._targets.size();
    }

    public void addPartialTarget(String clientId) {
        this._targets.put(clientId, Boolean.FALSE);
        int lastFragmentIndex = clientId.lastIndexOf(58);
        String id = lastFragmentIndex != -1 ? clientId.substring(lastFragmentIndex + 1) : clientId;
        this._targetIds.add(id);
        this._addSubtreeClientId(clientId);
    }

    public boolean isInsidePartialTarget() {
        return this._getCurrentPartialTarget() != null;
    }

    public void addRenderedPartialTarget(String clientId) {
        this._renderedTargets.add(clientId);
    }

    public Iterator<String> getRenderedPartialTargets() {
        return this._renderedTargets.iterator();
    }

    public VisitContext getVisitContext() {
        return this._visitContext;
    }

    public void pushRenderedPartialTarget(String clientId) {
        if (_LOG.isFine() && !this._targets.containsKey(clientId)) {
            _LOG.fine("Rendering partial target {0}, which was not requested", (Object)clientId);
        }
        this._targets.put(clientId, Boolean.TRUE);
        this._currentTargetStack.push(clientId);
        if (_LOG.isFiner()) {
            _LOG.finer("Pushed rendered PPR target " + clientId);
        }
    }

    public void popRenderedPartialTarget() {
        this._currentTargetStack.pop();
    }

    private String _getCurrentPartialTarget() {
        if (this._currentTargetStack.empty()) {
            return null;
        }
        return this._currentTargetStack.peek();
    }

    private void _addSubtreeClientId(String clientId) {
        char separator = ':';
        int length = clientId.length();
        for (int i = 0; i < length; ++i) {
            if (clientId.charAt(i) != separator) continue;
            String namingContainerClientId = clientId.substring(0, i);
            Collection<String> c = this._subtreeClientIds.get(namingContainerClientId);
            if (c == null) {
                c = new ArrayList<String>();
                this._subtreeClientIds.put(namingContainerClientId, c);
            }
            c.add(clientId);
        }
    }

    private class PartialPageVisitContext
    extends VisitContext {
        private PartialPageVisitContext() {
        }

        public FacesContext getFacesContext() {
            return PartialPageContextImpl.this._context;
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER_RESPONSE;
        }

        public Collection<String> getIdsToVisit() {
            return PartialPageContextImpl.this._unmodifiableTargets;
        }

        public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
            if (!(component instanceof NamingContainer)) {
                throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
            }
            String clientId = component.getClientId(this.getFacesContext());
            Collection ids = (Collection)PartialPageContextImpl.this._subtreeClientIds.get(clientId);
            if (ids == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(ids);
        }

        public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
            VisitResult result = component instanceof UIXComponent ? ((UIXComponent)component).partialEncodeVisit((VisitContext)this, (PartialPageContext)PartialPageContextImpl.this, callback) : (PartialPageContextImpl.this._targetIds.contains(component.getId()) && PartialPageContextImpl.this._targets.containsKey(component.getClientId(PartialPageContextImpl.this._context)) ? callback.visit((VisitContext)this, component) : VisitResult.ACCEPT);
            if (PartialPageContextImpl.this.areAllTargetsProcessed()) {
                return VisitResult.COMPLETE;
            }
            return result;
        }

        public Set<VisitHint> getHints() {
            return _PPR_VISIT_HINTS;
        }
    }
}

