/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class HiddenLabelUtils {
    private static final Object _LAST_LABEL_KEY = new Object();

    public static boolean supportsHiddenLabels(RenderingContext arc) {
        if (XhtmlRenderer.isInaccessibleMode((RenderingContext)arc)) {
            return false;
        }
        if (XhtmlRenderer.isScreenReaderMode((RenderingContext)arc)) {
            return true;
        }
        TrinidadAgent agent = ((CoreRenderingContext)arc).getTrinidadAgent();
        return HiddenLabelUtils.agentSupportsHiddenLabels(agent);
    }

    public static boolean agentSupportsHiddenLabels(TrinidadAgent agent) {
        switch (agent.getAgentApplication()) {
            case IEXPLORER: {
                if (agent.getAgentOS() == 1) {
                    if (agent.getAgentMajorVersion() == 4) {
                        return false;
                    }
                    return !Boolean.TRUE.equals(agent.getCapability(TrinidadAgent.CAP_IS_JDEV_VE));
                }
                return false;
            }
            case GECKO: 
            case SAFARI: {
                return true;
            }
        }
        return false;
    }

    public static boolean wantsHiddenLabel(RenderingContext arc, String id) {
        if (id == null) {
            return false;
        }
        return !id.equals(arc.getProperties().get(_LAST_LABEL_KEY));
    }

    public static void outputHiddenLabelIfNeeded(FacesContext context, RenderingContext arc, String id, Object text, UIComponent component) throws IOException {
        if (HiddenLabelUtils.supportsHiddenLabels(arc) && HiddenLabelUtils.wantsHiddenLabel(arc, id)) {
            HiddenLabelUtils.outputHiddenLabel(context, arc, id, text, component);
        }
    }

    public static void outputHiddenLabel(FacesContext context, RenderingContext arc, String id, Object text, UIComponent component) throws IOException {
        if (text != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("label", component);
            writer.writeAttribute("for", (Object)id, null);
            XhtmlRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"p_OraHiddenLabel");
            writer.writeText(text, null);
            writer.endElement("label");
        }
    }

    public static void rememberLabel(RenderingContext arc, Object id) {
        if (id != null) {
            arc.getProperties().put(_LAST_LABEL_KEY, id.toString());
        }
    }

    private HiddenLabelUtils() {
    }
}

