/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.MessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputLabelRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PanelFormLayoutRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public abstract class LabelAndMessageRenderer
extends XhtmlRenderer {
    public static final String INLINE_MESSAGE_DEFAULT_GAP = "12";
    public static final String INLINE_MESSAGE_PDA_GAP = "2";
    private static final Object _LABEL_CELL_WIDTH_KEY = "_imLCWidth";
    private static final Object _FIELD_CELL_WIDTH_KEY = "_imFCWidth";
    private static final String _LABEL_PSEUDO_ELEMENT = "::label";
    private PropertyKey _labelKey;
    private PropertyKey _requiredKey;
    private PropertyKey _showRequiredKey;
    private XhtmlRenderer _message;
    private XhtmlRenderer _label;
    private XhtmlRenderer _labelInTable;

    public LabelAndMessageRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._labelKey = type.findKey("label");
        this._requiredKey = type.findKey("required");
        this._showRequiredKey = type.findKey("showRequired");
        this._message = new Message(type);
        this._label = new Label(type, false);
        this._labelInTable = new Label(type, true);
    }

    private boolean _needsTableTag(UIComponent component) {
        UIComponent parent = XhtmlUtils.getStructuralParent(component);
        if (parent == null) {
            return true;
        }
        String family = parent.getFamily();
        return !"org.apache.myfaces.trinidad.TableLayout".equals(family);
    }

    private boolean _isParentPanelForm(FacesContext context, UIComponent component) {
        String rendererType;
        if (PanelFormLayoutRenderer.__isInPanelFormLayout(context, component)) {
            return true;
        }
        UIComponent parentComponent = component.getParent();
        String family = parentComponent.getFamily();
        while ("org.apache.myfaces.trinidad.Group".equals(family)) {
            if ((parentComponent = parentComponent.getParent()) == null) {
                return false;
            }
            family = parentComponent.getFamily();
        }
        return "org.apache.myfaces.trinidad.Panel".equals(family) && this._isFormRendererType(rendererType = parentComponent.getRendererType());
    }

    private boolean _isLabelStartAligned(FacesContext context, boolean needsPanelFormLayout) {
        if (LabelAndMessageRenderer.supportsNarrowScreen(RenderingContext.getCurrentInstance())) {
            return false;
        }
        if (needsPanelFormLayout) {
            Map requestMap = context.getExternalContext().getRequestMap();
            Object labelsStartAligned = requestMap.get("oracle.adfinternal.PanelFormLayoutLabelsStartAligned");
            return Boolean.TRUE.equals(labelsStartAligned);
        }
        return true;
    }

    protected void renderRootDomElementStyles(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    private boolean _isInTable() {
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        if (tContext != null) {
            return TableRenderingContext.isInsideContentOfTable();
        }
        return false;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        boolean isInline;
        String clientId = component.getClientId(context);
        if (this.isLeafRenderer() && this.canSkipRendering(rc, clientId)) {
            UIComponent help = LabelAndMessageRenderer.getFacet((UIComponent)component, (String)"help");
            if (help != null) {
                this.encodeChild(context, help);
            }
            return;
        }
        String saved = rc.getCurrentClientId();
        rc.setCurrentClientId(clientId);
        boolean isInTable = this._isInTable();
        if (this.hasOwnLabel(component, bean) || isInTable) {
            String value = this.getLabel(component, bean);
            FormData fd = rc.getFormData();
            if (fd != null) {
                fd.addLabel(clientId, value);
            }
        }
        RequestContext requestContext = RequestContext.getCurrentInstance();
        boolean needsPanelFormLayout = this._isParentPanelForm(context, component);
        boolean bl = isInline = requestContext.getClientValidation() == RequestContext.ClientValidation.INLINE;
        if (isInTable && !needsPanelFormLayout) {
            ResponseWriter rw = context.getResponseWriter();
            this.delegateRenderer(context, rc, component, bean, this._labelInTable);
            this.renderFieldCellContents(context, rc, component, bean);
            if (isInline || this.hasMessage(context, rc, component, bean)) {
                rw.startElement("div", null);
                rw.endElement("div");
                this._renderMessageCellContents(context, rc, component, bean);
            }
            this.renderEndFacetForNarrowPDA(context, rc, component, true);
        } else {
            ResponseWriter rw = context.getResponseWriter();
            boolean isLabelStartAligned = this._isLabelStartAligned(context, needsPanelFormLayout);
            boolean needsTableTag = !isLabelStartAligned || !needsPanelFormLayout && this._needsTableTag(component);
            boolean isPIE = "ppc".equalsIgnoreCase(rc.getAgent().getPlatformName());
            if (needsTableTag) {
                if (isPIE) {
                    rw.startElement("div", component);
                    this.renderId(context, component);
                    rw.startElement("table", null);
                } else {
                    rw.startElement("table", component);
                }
                rw.writeAttribute("title", (Object)this.getShortDesc(component, bean), "title");
                if (!LabelAndMessageRenderer.isDesktop((RenderingContext)rc)) {
                    rw.writeAttribute("width", (Object)"100%", null);
                }
                if (!isPIE) {
                    this.renderId(context, component);
                }
                this.renderRootDomElementStyles(context, rc, component, bean);
                OutputUtils.renderLayoutTableAttributes(context, rc, "0", null);
            }
            rw.startElement("tr", component);
            if (!needsTableTag) {
                this.renderId(context, component);
                this.renderRootDomElementStyles(context, rc, component, bean);
            }
            boolean labelExists = this.getLabel(component, bean) != null;
            this._renderLabelCell(context, rc, component, bean, labelExists);
            if (!isLabelStartAligned) {
                rw.endElement("tr");
                rw.startElement("tr", null);
            }
            Map requestMap = context.getExternalContext().getRequestMap();
            Integer hspaceObject = (Integer)requestMap.get("org.apache.myfaces.trinidadinternal.TableFormHspace");
            Boolean percentWidthObject = (Boolean)requestMap.get("org.apache.myfaces.trinidadinternal.TableFormPercentWidth");
            if (hspaceObject != null) {
                rw.startElement("td", null);
                if (percentWidthObject != null && percentWidthObject.booleanValue()) {
                    rw.writeAttribute("width", (Object)(hspaceObject + "%"), null);
                } else {
                    rw.writeAttribute("width", (Object)hspaceObject, null);
                }
                rw.endElement("td");
            }
            this._renderFieldCell(context, rc, component, bean, labelExists, needsPanelFormLayout, isInline);
            rw.endElement("tr");
            if (!needsPanelFormLayout && (isInline || this.hasMessage(context, rc, component, bean))) {
                rw.startElement("tr", null);
                if (isLabelStartAligned) {
                    rw.startElement("td", null);
                    rw.endElement("td");
                }
                rw.startElement("td", null);
                LabelAndMessageRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"AFComponentMessageCell");
                this._renderMessageCellContents(context, rc, component, bean);
                rw.endElement("td");
                rw.endElement("tr");
            }
            this.renderEndFacetForNarrowPDA(context, rc, component, false);
            if (needsTableTag) {
                rw.endElement("table");
                if (isPIE) {
                    rw.endElement("div");
                }
            }
        }
        rc.setCurrentClientId(saved);
    }

    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return null;
    }

    private void _renderLabelCell(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean labelExists) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("td", null);
        LabelAndMessageRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])new String[]{this.getLabelStyleClass(component, bean), this._getDefaultLabelStyleClass(rc, "AFLabelText")});
        String labelInlineStyle = this.getLabelInlineStyleKey(component, bean);
        if (LabelAndMessageRenderer.supportsNarrowScreen(rc)) {
            labelInlineStyle = labelInlineStyle + ";text-align: left;";
        }
        rw.writeAttribute("style", (Object)labelInlineStyle, null);
        String valign = this.getDefaultLabelValign(component, bean);
        rw.writeAttribute("valign", (Object)valign, null);
        if (LabelAndMessageRenderer.isDesktop((RenderingContext)rc)) {
            rw.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
        if (labelExists) {
            rw.writeAttribute("width", rc.getProperties().get(_LABEL_CELL_WIDTH_KEY), null);
        }
        this.delegateRenderer(context, rc, component, bean, this._label);
        rw.endElement("td");
    }

    private void _renderFieldCell(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean labelExists, boolean needsPanelFormLayout, boolean isInline) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("td", null);
        rw.writeAttribute("valign", (Object)"top", null);
        if (LabelAndMessageRenderer.isDesktop((RenderingContext)rc)) {
            rw.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
        LabelAndMessageRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"AFContentCell");
        if (labelExists) {
            rw.writeAttribute("width", rc.getProperties().get(_FIELD_CELL_WIDTH_KEY), null);
        }
        this.renderFieldCellContents(context, rc, component, bean);
        if (needsPanelFormLayout && (isInline || this.hasMessage(context, rc, component, bean))) {
            rw.startElement("div", null);
            LabelAndMessageRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"AFComponentMessageCell");
            this._renderMessageCellContents(context, rc, component, bean);
            rw.endElement("div");
        }
        if (LabelAndMessageRenderer.isPDA((RenderingContext)rc) && LabelAndMessageRenderer.isIE((RenderingContext)rc)) {
            rw.startElement("div", null);
            this.renderSpacer(context, rc, "1", "0");
            rw.endElement("div");
        }
        rw.endElement("td");
    }

    static String __getCachedClientId(RenderingContext rc) {
        String clientId = rc.getCurrentClientId();
        assert (clientId != null);
        return clientId;
    }

    protected String getFieldCellContentsStyleClass(UIComponent component, FacesBean bean) {
        return null;
    }

    protected String getFooterContentsStyleClass(UIComponent component, FacesBean bean) {
        return null;
    }

    protected boolean hasMessage(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        UIComponent help = LabelAndMessageRenderer.getFacet((UIComponent)component, (String)"help");
        if (help != null) {
            return true;
        }
        String id = this.getLabelFor(context, rc, component, bean);
        return context.getMessages(id).hasNext();
    }

    private void _renderMessageCellContents(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRenderer(context, rc, component, bean, this._message);
    }

    protected String getClientId(FacesContext context, UIComponent component) {
        return super.getClientId(context, component) + "__xc_";
    }

    protected boolean isLeafRenderer() {
        return true;
    }

    protected String getDefaultLabelValign(UIComponent component, FacesBean bean) {
        return null;
    }

    protected abstract void renderFieldCellContents(FacesContext var1, RenderingContext var2, UIComponent var3, FacesBean var4) throws IOException;

    protected void renderFieldFooterContents(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
    }

    protected boolean isContentEditable(UIComponent component, FacesBean bean) {
        return true;
    }

    protected boolean isIndented() {
        return false;
    }

    protected boolean hasOwnLabel(UIComponent component, FacesBean bean) {
        return false;
    }

    protected boolean showAccessKeyOnLabel(UIComponent component, FacesBean bean) {
        return !this.hasOwnLabel(component, bean);
    }

    protected abstract String getLabelFor(FacesContext var1, RenderingContext var2, UIComponent var3, FacesBean var4);

    static void __setLabelWidth(RenderingContext rc, Object width) {
        rc.getProperties().put(_LABEL_CELL_WIDTH_KEY, width);
    }

    static void __setFieldWidth(RenderingContext rc, Object width) {
        rc.getProperties().put(_FIELD_CELL_WIDTH_KEY, width);
    }

    static void __clearProperties(RenderingContext rc) {
        rc.getProperties().remove(_LABEL_CELL_WIDTH_KEY);
        rc.getProperties().remove(_FIELD_CELL_WIDTH_KEY);
    }

    protected String getLabelInlineStyleKey(UIComponent component, FacesBean bean) {
        return null;
    }

    protected boolean labelShowRequired(UIComponent component, FacesBean bean) {
        if (this.getRequired(component, bean) || this.getShowRequired(component, bean)) {
            return this.isContentEditable(component, bean);
        }
        return false;
    }

    protected boolean getShowRequired(UIComponent component, FacesBean bean) {
        if (this._showRequiredKey == null) {
            return false;
        }
        Object o = bean.getProperty(this._showRequiredKey);
        if (o == null) {
            o = this._showRequiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getRequired(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._requiredKey);
        if (o == null) {
            o = this._requiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getLabel(UIComponent component, FacesBean bean) {
        return LabelAndMessageRenderer.toString((Object)bean.getProperty(this._labelKey));
    }

    protected String getLabelStyleClass(UIComponent component, FacesBean bean) {
        String styleClass = this.getRootStyleClass(component, bean);
        if (styleClass != null) {
            styleClass = styleClass + _LABEL_PSEUDO_ELEMENT;
        }
        return styleClass;
    }

    protected void renderEndFacetForNarrowPDA(FacesContext context, RenderingContext rc, UIComponent component, boolean insideTableData) throws IOException {
    }

    private String _getDefaultLabelStyleClass(RenderingContext rc, String styleClass) {
        Map keyMap = rc.getSkinResourceKeyMap();
        return keyMap != null ? (String)keyMap.get(styleClass) : null;
    }

    private boolean _isFormRendererType(String rendererType) {
        return "org.apache.myfaces.trinidad.Form".equals(rendererType) || "org.apache.myfaces.trinidad.FormLayout".equals(rendererType) || "org.apache.myfaces.trinidad.rich.Form".equals(rendererType) || "org.apache.myfaces.trinidad.TableLayout".equals(rendererType);
    }

    private class Message
    extends MessageRenderer {
        public Message(FacesBean.Type type) {
            super(type);
        }

        @Override
        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return false;
        }

        @Override
        protected String getShortDesc(UIComponent component, FacesBean bean) {
            return null;
        }

        @Override
        protected boolean getIndented(UIComponent component, FacesBean bean) {
            return LabelAndMessageRenderer.this.isIndented();
        }

        @Override
        protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        }

        @Override
        protected String getForId(FacesContext context, UIComponent component, FacesBean bean) {
            return LabelAndMessageRenderer.this.getLabelFor(context, RenderingContext.getCurrentInstance(), component, bean);
        }
    }

    private class Label
    extends OutputLabelRenderer {
        private final boolean _inTable;

        public Label(FacesBean.Type type, boolean inTable) {
            super(type);
            this._inTable = inTable;
        }

        @Override
        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return false;
        }

        @Override
        protected boolean needComponentInStartElement() {
            return false;
        }

        @Override
        protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        }

        @Override
        protected String getDefaultValign(UIComponent component, FacesBean bean) {
            return LabelAndMessageRenderer.this.getDefaultLabelValign(component, bean);
        }

        @Override
        protected String getConvertedString(FacesContext context, UIComponent component, FacesBean bean) {
            if (this._inTable) {
                return null;
            }
            return LabelAndMessageRenderer.this.getLabel(component, bean);
        }

        @Override
        protected boolean getShowRequired(UIComponent component, FacesBean bean) {
            if (this._inTable) {
                return false;
            }
            return LabelAndMessageRenderer.this.labelShowRequired(component, bean);
        }

        @Override
        protected char getAccessKey(UIComponent component, FacesBean bean) {
            if (LabelAndMessageRenderer.this.showAccessKeyOnLabel(component, bean)) {
                return super.getAccessKey(component, bean);
            }
            return '\uffff';
        }

        @Override
        protected String getShortDesc(UIComponent component, FacesBean bean) {
            String shortDesc = super.getShortDesc(component, bean);
            if (shortDesc == null && this._inTable) {
                shortDesc = LabelAndMessageRenderer.this.getLabel(component, bean);
            }
            return shortDesc;
        }

        @Override
        protected String getForId(FacesContext context, UIComponent component, FacesBean bean) {
            return LabelAndMessageRenderer.this.getLabelFor(context, RenderingContext.getCurrentInstance(), component, bean);
        }

        @Override
        protected boolean isLabelTagNeeded(RenderingContext rc, UIComponent component, FacesBean bean, String forId, int accessKeyIndex) {
            if (LabelAndMessageRenderer.this.hasOwnLabel(component, bean)) {
                return false;
            }
            return super.isLabelTagNeeded(rc, component, bean, forId, accessKeyIndex);
        }
    }
}

