/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreMessage;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

public class MessageRenderer
extends ValueRenderer {
    private PropertyKey _forKey;
    private PropertyKey _messageTypeKey;
    private PropertyKey _messageKey;
    private static final String _sLTR_INDENTED_STYLE = "margin-left:21px";
    private static final String _sRTL_INDENTED_STYLE = "margin-right:21px";

    public MessageRenderer() {
        this(CoreMessage.TYPE);
    }

    protected MessageRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._forKey = type.findKey("for");
        this._messageTypeKey = type.findKey("messageType");
        this._messageKey = type.findKey("message");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected String getInlineStyle(UIComponent component, FacesBean bean) {
        String beanInlineStyle = super.getInlineStyle(component, bean);
        String inlineStyle = null;
        if (this.getIndented(component, bean)) {
            String string = inlineStyle = RenderingContext.getCurrentInstance().isRightToLeft() ? _sRTL_INDENTED_STYLE : _sLTR_INDENTED_STYLE;
        }
        if (inlineStyle != null && beanInlineStyle != null) {
            StringBuffer buffer = new StringBuffer(inlineStyle.length() + beanInlineStyle.length() + 1);
            buffer.append(inlineStyle);
            if (!inlineStyle.endsWith(";")) {
                buffer.append(";");
            }
            buffer.append(beanInlineStyle);
            return buffer.toString();
        }
        if (inlineStyle != null) {
            return inlineStyle;
        }
        return beanInlineStyle;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        boolean isInline;
        FacesMessage facesMessage;
        ResponseWriter writer = context.getResponseWriter();
        String message = this.getMessage(component, bean);
        String messageType = this.getMessageType(component, bean);
        String forId = this.getForId(context, component, bean);
        if ((message == null || messageType == null) && (facesMessage = MessageUtils.getFacesMessage(context, forId)) != null) {
            if (message == null) {
                message = facesMessage.getDetail();
            }
            if (messageType == null) {
                messageType = MessageUtils.getMessageTypeFromSeverity(facesMessage.getSeverity());
            }
        }
        UIComponent help = MessageRenderer.getFacet((UIComponent)component, (String)"help");
        boolean isError = true;
        if (messageType != null) {
            isError = "error".equals(messageType);
        }
        boolean hasHelp = help != null;
        boolean hasMessage = message != null;
        RequestContext requestContext = RequestContext.getCurrentInstance();
        boolean bl = isInline = requestContext.getClientValidation() == RequestContext.ClientValidation.INLINE;
        if (hasHelp) {
            writer.startElement("span", component);
            if (this.shouldRenderId(context, component)) {
                writer.writeAttribute("id", (Object)(forId + "::help"), null);
            }
            this.renderAllAttributes(context, rc, component, bean, false);
            this.renderStyleAttributes(context, rc, component, bean, "OraInlineInfoText");
            this.encodeChild(context, help);
            if (hasMessage || isInline) {
                writer.startElement("br", null);
                writer.endElement("br");
            }
            writer.endElement("span");
        }
        if (hasMessage || isInline && !MessageRenderer.isPDA((RenderingContext)rc)) {
            writer.startElement("span", component);
            if (this.shouldRenderId(context, component) || isInline && forId != null) {
                writer.writeAttribute("id", (Object)(forId + "::msg"), null);
            }
            this.renderAllAttributes(context, rc, component, bean, false);
            if (hasMessage) {
                this.renderStyleAttributes(context, rc, component, bean, isError ? "OraInlineErrorText" : "OraInlineInfoText");
                this.renderPossiblyFormattedText(context, message);
            } else {
                writer.writeAttribute("style", (Object)"display:none;", null);
            }
            writer.endElement("span");
        }
    }

    protected boolean getIndented(UIComponent component, FacesBean bean) {
        return false;
    }

    protected String getFor(UIComponent component, FacesBean bean) {
        return MessageRenderer.toString((Object)bean.getProperty(this._forKey));
    }

    protected String getMessageType(UIComponent component, FacesBean bean) {
        if (this._messageTypeKey == null) {
            return null;
        }
        return MessageRenderer.toString((Object)bean.getProperty(this._messageTypeKey));
    }

    protected String getMessage(UIComponent component, FacesBean bean) {
        if (this._messageKey == null) {
            return null;
        }
        return MessageRenderer.toString((Object)bean.getProperty(this._messageKey));
    }

    protected String getForId(FacesContext context, UIComponent component, FacesBean bean) {
        String forValue = this.getFor(component, bean);
        if (forValue == null) {
            return null;
        }
        return MessageUtils.getClientIdFor(context, component, forValue);
    }
}

