/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.util.GenericBeanInfo;

public class JavaIntrospector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static final Class<EventListener> _EVENT_LISTENER_TYPE = EventListener.class;
    private static final String _READ_PREFIX = "get";
    private static final String _WRITE_PREFIX = "set";
    private static final String[] _BOOLEAN_READ_PREFIXES = new String[]{"is", "has"};
    private boolean _propertyChangeSource = false;
    private Class<?> _beanClass;
    private BeanInfo _superBeanInfo;
    private BeanInfo _informant;
    private BeanInfo[] _additionalBeanInfo;
    private String _defaultEventName;
    private String _defaultPropertyName;
    private int _defaultEventIndex = -1;
    private int _defaultPropertyIndex = -1;
    private static Hashtable<Class<?>, BeanInfo> _sBeanInfoCache = new Hashtable();
    private static Hashtable<Class<?>, Method[]> _sPublicMethodCache = new Hashtable();
    private static boolean _sDeclaredAccessOK = true;
    private static String[] _sSearchPath = new String[]{"sun.beans.infos"};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(JavaIntrospector.class);

    public static BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        GenericBeanInfo bi = (GenericBeanInfo)_sBeanInfoCache.get(beanClass);
        if (bi == null) {
            JavaIntrospector introspector = new JavaIntrospector(beanClass, null, 1);
            bi = introspector._getBeanInfo();
            _sBeanInfoCache.put(beanClass, bi);
        }
        return new GenericBeanInfo(bi);
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, int flags) throws IntrospectionException {
        if (flags == 1) {
            return JavaIntrospector.getBeanInfo(beanClass);
        }
        return new JavaIntrospector(beanClass, null, flags)._getBeanInfo();
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        if (stopClass == null) {
            return JavaIntrospector.getBeanInfo(beanClass);
        }
        return new JavaIntrospector(beanClass, stopClass, 1)._getBeanInfo();
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String[] getBeanInfoSearchPath() {
        if (_sSearchPath == null) {
            return null;
        }
        return (String[])_sSearchPath.clone();
    }

    public static void setBeanInfoSearchPath(String[] path) {
        _sSearchPath = path == null ? null : (String[])path.clone();
    }

    public static void flushCaches() {
        _sBeanInfoCache.clear();
        _sPublicMethodCache.clear();
    }

    public static void flushFromCaches(Class<?> targetClass) {
        _sBeanInfoCache.remove(targetClass);
        _sPublicMethodCache.remove(targetClass);
    }

    private JavaIntrospector(Class<?> beanClass, Class<?> stopClass, int flags) throws IntrospectionException {
        Class<?> superClass;
        this._beanClass = beanClass;
        if (stopClass != null) {
            boolean isSuper = false;
            for (Class<?> c = beanClass.getSuperclass(); c != null; c = c.getSuperclass()) {
                if (c != stopClass) continue;
                isSuper = true;
            }
            if (!isSuper) {
                throw new IntrospectionException(_LOG.getMessage("NOT_SUPERCLASS_OF", new Object[]{stopClass.getName(), beanClass.getName()}));
            }
        }
        if (flags == 1) {
            this._informant = this._findInformant(beanClass);
        }
        if ((superClass = beanClass.getSuperclass()) != stopClass) {
            int newFlags = flags;
            if (newFlags == 2) {
                newFlags = 1;
            }
            if (stopClass == null && newFlags == 1) {
                this._superBeanInfo = _sBeanInfoCache.get(superClass);
                if (this._superBeanInfo == null) {
                    JavaIntrospector ins = new JavaIntrospector(superClass, null, 1);
                    this._superBeanInfo = ins._getBeanInfo();
                    _sBeanInfoCache.put(superClass, this._superBeanInfo);
                }
            } else {
                JavaIntrospector ins = new JavaIntrospector(superClass, stopClass, newFlags);
                this._superBeanInfo = ins._getBeanInfo();
            }
        }
        if (this._informant != null) {
            this._additionalBeanInfo = this._informant.getAdditionalBeanInfo();
        }
        if (this._additionalBeanInfo == null) {
            this._additionalBeanInfo = new BeanInfo[0];
        }
    }

    private GenericBeanInfo _getBeanInfo() throws IntrospectionException {
        return new GenericBeanInfo(this, this._informant);
    }

    private BeanInfo _findInformant(Class<?> beanClass) {
        String name = beanClass.getName() + "BeanInfo";
        try {
            return (BeanInfo)JavaIntrospector._instantiate(beanClass, name);
        }
        catch (Exception ex) {
            try {
                if (JavaIntrospector._isSubclass(beanClass, BeanInfo.class)) {
                    return (BeanInfo)beanClass.newInstance();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            while (name.indexOf(46) > 0) {
                name = name.substring(name.indexOf(46) + 1);
            }
            for (int i = 0; i < _sSearchPath.length; ++i) {
                try {
                    String fullName = _sSearchPath[i] + "." + name;
                    return (BeanInfo)JavaIntrospector._instantiate(beanClass, fullName);
                }
                catch (Exception ex3) {
                    continue;
                }
            }
            return null;
        }
    }

    PropertyDescriptor[] __getTargetPropertyInfo() throws IntrospectionException {
        int i;
        int i2;
        Hashtable<String, PropertyDescriptor> properties = new Hashtable<String, PropertyDescriptor>();
        PropertyDescriptor[] explicit = null;
        if (this._informant != null) {
            explicit = this._informant.getPropertyDescriptors();
            int ix = this._informant.getDefaultPropertyIndex();
            if (ix >= 0 && ix < explicit.length) {
                this._defaultPropertyName = explicit[ix].getName();
            }
        }
        if (explicit == null && this._superBeanInfo != null) {
            PropertyDescriptor[] supers = this._superBeanInfo.getPropertyDescriptors();
            for (i2 = 0; i2 < supers.length; ++i2) {
                this._addProperty(properties, supers[i2]);
            }
            int ix = this._superBeanInfo.getDefaultPropertyIndex();
            if (ix >= 0 && ix < supers.length) {
                this._defaultPropertyName = supers[ix].getName();
            }
        }
        for (i = 0; i < this._additionalBeanInfo.length; ++i) {
            PropertyDescriptor[] additional = this._additionalBeanInfo[i].getPropertyDescriptors();
            if (additional == null) continue;
            for (int j = 0; j < additional.length; ++j) {
                this._addProperty(properties, additional[j]);
            }
        }
        if (explicit != null) {
            for (i = 0; i < explicit.length; ++i) {
                this._addProperty(properties, explicit[i]);
            }
        } else {
            Method[] methodList = JavaIntrospector._getPublicMethods(this._beanClass);
            for (i2 = 0; i2 < methodList.length; ++i2) {
                Method method = methodList[i2];
                if (Modifier.isStatic(method.getModifiers())) continue;
                String name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> resultType = method.getReturnType();
                int argCount = argTypes.length;
                PropertyDescriptor pd = null;
                try {
                    if (argCount == 0) {
                        if (name.startsWith(_READ_PREFIX)) {
                            pd = new PropertyDescriptor(JavaIntrospector.decapitalize(name.substring(_READ_PREFIX.length())), method, null);
                        } else if (resultType == Boolean.TYPE) {
                            for (int j = 0; j < _BOOLEAN_READ_PREFIXES.length; ++j) {
                                String currPrefix = _BOOLEAN_READ_PREFIXES[j];
                                if (!name.startsWith(currPrefix)) continue;
                                pd = new PropertyDescriptor(JavaIntrospector.decapitalize(name.substring(currPrefix.length())), method, null);
                            }
                        }
                    } else if (argCount == 1) {
                        if (argTypes[0] == Integer.TYPE && name.startsWith(_READ_PREFIX)) {
                            pd = new IndexedPropertyDescriptor(JavaIntrospector.decapitalize(name.substring(_READ_PREFIX.length())), null, null, method, null);
                        } else if (resultType == Void.TYPE && name.startsWith(_WRITE_PREFIX)) {
                            pd = new PropertyDescriptor(JavaIntrospector.decapitalize(name.substring(_WRITE_PREFIX.length())), null, method);
                            if (this._throwsException(method, PropertyVetoException.class)) {
                                pd.setConstrained(true);
                            }
                        }
                    } else if (argCount == 2 && argTypes[0] == Integer.TYPE && name.startsWith(_WRITE_PREFIX)) {
                        pd = new IndexedPropertyDescriptor(JavaIntrospector.decapitalize(name.substring(_WRITE_PREFIX.length())), null, null, null, method);
                        if (this._throwsException(method, PropertyVetoException.class)) {
                            pd.setConstrained(true);
                        }
                    }
                }
                catch (IntrospectionException ex) {
                    pd = null;
                }
                if (pd == null) continue;
                if (this._propertyChangeSource) {
                    pd.setBound(true);
                }
                this._addProperty(properties, pd);
            }
        }
        Enumeration<Object> elements = properties.elements();
        while (elements.hasMoreElements()) {
            Method writeMethod;
            IndexedPropertyDescriptor indexedElement;
            Object currElement = elements.nextElement();
            if (!(currElement instanceof IndexedPropertyDescriptor) || (indexedElement = (IndexedPropertyDescriptor)currElement).getIndexedReadMethod() != null || (writeMethod = indexedElement.getIndexedWriteMethod()) == null || writeMethod.getParameterTypes()[1] != Integer.TYPE) continue;
            properties.remove(indexedElement.getName());
        }
        PropertyDescriptor[] result = new PropertyDescriptor[properties.size()];
        elements = properties.elements();
        for (int i3 = 0; i3 < result.length; ++i3) {
            result[i3] = (PropertyDescriptor)elements.nextElement();
            if (this._defaultPropertyName == null || !this._defaultPropertyName.equals(result[i3].getName())) continue;
            this._defaultPropertyIndex = i3;
        }
        return result;
    }

    private void _addProperty(Hashtable<String, PropertyDescriptor> properties, PropertyDescriptor newDescriptor) {
        Class<?> newDescriptorType;
        Class<?> oldDescriptorType;
        PropertyDescriptor putDescriptor = newDescriptor;
        String name = newDescriptor.getName();
        PropertyDescriptor oldDescriptor = properties.get(name);
        if (oldDescriptor != null && ((oldDescriptorType = oldDescriptor.getPropertyType()) == (newDescriptorType = newDescriptor.getPropertyType()) || oldDescriptorType == null || newDescriptorType == null)) {
            if (oldDescriptor instanceof IndexedPropertyDescriptor || newDescriptor instanceof IndexedPropertyDescriptor) {
                putDescriptor = JavaIntrospector._createMergedIndexedDescriptor(oldDescriptor, newDescriptor);
                if (putDescriptor == null) {
                    putDescriptor = !(oldDescriptor instanceof IndexedPropertyDescriptor) ? oldDescriptor : newDescriptor;
                }
            } else {
                putDescriptor = JavaIntrospector._createMergedPropertyDescriptor(oldDescriptor, newDescriptor);
            }
        }
        properties.put(name, putDescriptor);
    }

    EventSetDescriptor[] __getTargetEventInfo() throws IntrospectionException {
        int i;
        Hashtable<String, EventSetDescriptor> events = new Hashtable<String, EventSetDescriptor>();
        EventSetDescriptor[] explicit = null;
        if (this._informant != null) {
            explicit = this._informant.getEventSetDescriptors();
            int ix = this._informant.getDefaultEventIndex();
            if (ix >= 0 && ix < explicit.length) {
                this._defaultEventName = explicit[ix].getName();
            }
        }
        if (explicit == null && this._superBeanInfo != null) {
            EventSetDescriptor[] supers = this._superBeanInfo.getEventSetDescriptors();
            for (int i2 = 0; i2 < supers.length; ++i2) {
                this._addEvent(events, supers[i2]);
            }
            int ix = this._superBeanInfo.getDefaultEventIndex();
            if (ix >= 0 && ix < supers.length) {
                this._defaultEventName = supers[ix].getName();
            }
        }
        for (i = 0; i < this._additionalBeanInfo.length; ++i) {
            EventSetDescriptor[] additional = this._additionalBeanInfo[i].getEventSetDescriptors();
            if (additional == null) continue;
            for (int j = 0; j < additional.length; ++j) {
                this._addEvent(events, additional[j]);
            }
        }
        if (explicit != null) {
            for (i = 0; i < explicit.length; ++i) {
                this._addEvent(events, explicit[i]);
            }
        } else {
            Method[] methodList = JavaIntrospector._getPublicMethods(this._beanClass);
            Hashtable<String, Method> adds = new Hashtable<String, Method>();
            Hashtable<String, Method> removes = new Hashtable<String, Method>();
            for (int i3 = 0; i3 < methodList.length; ++i3) {
                String compound;
                Method method = methodList[i3];
                if (Modifier.isStatic(method.getModifiers())) continue;
                String name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> resultType = method.getReturnType();
                if (name.startsWith("add") && argTypes.length == 1 && resultType == Void.TYPE) {
                    compound = name.substring(3) + ":" + argTypes[0];
                    adds.put(compound, method);
                    continue;
                }
                if (!name.startsWith("remove") || argTypes.length != 1 || resultType != Void.TYPE) continue;
                compound = name.substring(6) + ":" + argTypes[0];
                removes.put(compound, method);
            }
            Enumeration keys = adds.keys();
            while (keys.hasMoreElements()) {
                String compound = (String)keys.nextElement();
                if (removes.get(compound) == null || compound.indexOf("Listener:") <= 0) continue;
                String listenerName = compound.substring(0, compound.indexOf(58));
                String eventName = JavaIntrospector.decapitalize(listenerName.substring(0, listenerName.length() - 8));
                Method addMethod = (Method)adds.get(compound);
                Method removeMethod = (Method)removes.get(compound);
                Class<?> argType = addMethod.getParameterTypes()[0];
                if (!JavaIntrospector._isSubclass(argType, _EVENT_LISTENER_TYPE)) continue;
                Method[] allMethods = argType.getMethods();
                int count = 0;
                for (int i4 = 0; i4 < allMethods.length; ++i4) {
                    if (this._isEventHandler(allMethods[i4])) {
                        ++count;
                        continue;
                    }
                    allMethods[i4] = null;
                }
                Method[] methods = new Method[count];
                int j = 0;
                for (int i5 = 0; i5 < allMethods.length; ++i5) {
                    if (allMethods[i5] == null) continue;
                    methods[j++] = allMethods[i5];
                }
                EventSetDescriptor esd = new EventSetDescriptor(eventName, argType, methods, addMethod, removeMethod);
                if (this._throwsException(addMethod, TooManyListenersException.class)) {
                    esd.setUnicast(true);
                }
                this._addEvent(events, esd);
            }
        }
        EventSetDescriptor[] result = new EventSetDescriptor[events.size()];
        Enumeration<EventSetDescriptor> elements = events.elements();
        for (int i6 = 0; i6 < result.length; ++i6) {
            result[i6] = elements.nextElement();
            if (this._defaultEventName == null || !this._defaultEventName.equals(result[i6].getName())) continue;
            this._defaultEventIndex = i6;
        }
        return result;
    }

    private void _addEvent(Hashtable<String, EventSetDescriptor> events, EventSetDescriptor descriptor) {
        EventSetDescriptor oldDescriptor;
        String key = descriptor.getName() + descriptor.getListenerType();
        if (descriptor.getName().equals("propertyChange")) {
            this._propertyChangeSource = true;
        }
        if ((oldDescriptor = events.get(key)) == null) {
            events.put(key, descriptor);
            return;
        }
        EventSetDescriptor composite = JavaIntrospector._createMergedEventSetDescriptor(oldDescriptor, descriptor);
        events.put(key, composite);
    }

    MethodDescriptor[] __getTargetMethodInfo() throws IntrospectionException {
        int i;
        int i2;
        MethodDescriptor[] explicit = null;
        Hashtable<String, MethodDescriptor> methods = new Hashtable<String, MethodDescriptor>();
        if (this._informant != null) {
            explicit = this._informant.getMethodDescriptors();
        }
        if (explicit == null && this._superBeanInfo != null) {
            MethodDescriptor[] supers = this._superBeanInfo.getMethodDescriptors();
            for (i2 = 0; i2 < supers.length; ++i2) {
                this._addMethod(methods, supers[i2]);
            }
        }
        for (i = 0; i < this._additionalBeanInfo.length; ++i) {
            MethodDescriptor[] additional = this._additionalBeanInfo[i].getMethodDescriptors();
            if (additional == null) continue;
            for (int j = 0; j < additional.length; ++j) {
                this._addMethod(methods, additional[j]);
            }
        }
        if (explicit != null) {
            for (i = 0; i < explicit.length; ++i) {
                this._addMethod(methods, explicit[i]);
            }
        } else {
            Method[] methodList = JavaIntrospector._getPublicMethods(this._beanClass);
            for (i2 = 0; i2 < methodList.length; ++i2) {
                this._addMethod(methods, new MethodDescriptor(methodList[i2]));
            }
        }
        MethodDescriptor[] result = new MethodDescriptor[methods.size()];
        Enumeration<MethodDescriptor> elements = methods.elements();
        for (int i3 = 0; i3 < result.length; ++i3) {
            result[i3] = elements.nextElement();
        }
        return result;
    }

    private void _addMethod(Hashtable<String, MethodDescriptor> methods, MethodDescriptor descriptor) {
        String name = descriptor.getMethod().getName();
        MethodDescriptor old = methods.get(name);
        if (old == null) {
            methods.put(name, descriptor);
            return;
        }
        Class<?>[] p1 = descriptor.getMethod().getParameterTypes();
        Class<?>[] p2 = old.getMethod().getParameterTypes();
        boolean match = false;
        if (p1.length == p2.length) {
            match = true;
            for (int i = 0; i < p1.length; ++i) {
                if (p1[i] == p2[i]) continue;
                match = false;
                break;
            }
        }
        if (match) {
            MethodDescriptor composite = JavaIntrospector._createMergedMethodDescriptor(old, descriptor);
            methods.put(name, composite);
            return;
        }
        String longKey = this._makeQualifiedMethodName(descriptor);
        old = methods.get(longKey);
        if (old == null) {
            methods.put(longKey, descriptor);
            return;
        }
        MethodDescriptor composite = JavaIntrospector._createMergedMethodDescriptor(old, descriptor);
        methods.put(longKey, composite);
    }

    private String _makeQualifiedMethodName(MethodDescriptor descriptor) {
        Method m = descriptor.getMethod();
        StringBuffer sb = new StringBuffer();
        sb.append(m.getName());
        sb.append("=");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sb.append(":");
            sb.append(params[i].getName());
        }
        return sb.toString();
    }

    int __getTargetDefaultEventIndex() {
        return this._defaultEventIndex;
    }

    int __getTargetDefaultPropertyIndex() {
        return this._defaultPropertyIndex;
    }

    BeanDescriptor __getTargetBeanDescriptor() throws IntrospectionException {
        BeanDescriptor bd;
        if (this._informant != null && (bd = this._informant.getBeanDescriptor()) != null) {
            return bd;
        }
        return new BeanDescriptor(this._beanClass);
    }

    private boolean _isEventHandler(Method m) throws IntrospectionException {
        try {
            Class<?>[] argTypes = m.getParameterTypes();
            if (argTypes.length != 1) {
                return false;
            }
            return JavaIntrospector._isSubclass(argTypes[0], EventObject.class);
        }
        catch (Exception ex) {
            throw new IntrospectionException("Unexpected reflection exception: " + ex);
        }
    }

    private static synchronized Method[] _getPublicMethods(Class<?> targetClass) {
        Object[] declaredMethods = _sPublicMethodCache.get(targetClass);
        if (declaredMethods == null) {
            int numDeclaredMethods;
            if (_sDeclaredAccessOK) {
                try {
                    declaredMethods = targetClass.getDeclaredMethods();
                }
                catch (SecurityException e) {
                    _sDeclaredAccessOK = false;
                }
            }
            if (declaredMethods == null) {
                try {
                    declaredMethods = targetClass.getMethods();
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            if (declaredMethods != null && (numDeclaredMethods = declaredMethods.length) > 0) {
                Vector<Method> publicMethods = new Vector<Method>(numDeclaredMethods);
                for (int i = 0; i < numDeclaredMethods; ++i) {
                    Method currMethod = declaredMethods[i];
                    if (!Modifier.isPublic(currMethod.getModifiers()) || currMethod.getDeclaringClass() != targetClass) continue;
                    publicMethods.addElement(currMethod);
                }
                declaredMethods = new Method[publicMethods.size()];
                publicMethods.copyInto(declaredMethods);
            }
            _sPublicMethodCache.put(targetClass, (Method[])declaredMethods);
        }
        return declaredMethods;
    }

    private static Method _internalFindMethod(Class<?> start, String methodName, int argCount) {
        for (Class<?> cl = start; cl != null; cl = cl.getSuperclass()) {
            Method[] methods = JavaIntrospector._getPublicMethods(cl);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                int mods = method.getModifiers();
                if (Modifier.isStatic(mods) || !Modifier.isPublic(mods) || !method.getName().equals(methodName) || method.getParameterTypes().length != argCount) continue;
                return method;
            }
        }
        Class<?>[] ifcs = start.getInterfaces();
        for (int i = 0; i < ifcs.length; ++i) {
            Method m = JavaIntrospector._internalFindMethod(ifcs[i], methodName, argCount);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    static boolean _isSubclass(Class<?> a, Class<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class<?> x = a; x != null; x = x.getSuperclass()) {
            if (x == b) {
                return true;
            }
            if (!b.isInterface()) continue;
            Class<?>[] interfaces = x.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!JavaIntrospector._isSubclass(interfaces[i], b)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _throwsException(Method method, Class<?> exception) {
        Class<?>[] exs = method.getExceptionTypes();
        for (int i = 0; i < exs.length; ++i) {
            if (exs[i] != exception) continue;
            return true;
        }
        return false;
    }

    private static Object _instantiate(Class<?> sibling, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Class cls = ClassLoaderUtils.loadClass((String)className);
        return cls.newInstance();
    }

    private static IndexedPropertyDescriptor _createMergedIndexedDescriptor(PropertyDescriptor secondaryDescriptor, PropertyDescriptor primaryDescriptor) {
        Method readMethod = JavaIntrospector._getMergedReadMethod(secondaryDescriptor, primaryDescriptor);
        Method writeMethod = JavaIntrospector._getMergedWriteMethod(secondaryDescriptor, primaryDescriptor);
        Method indexedReadMethod = null;
        Method indexedWriteMethod = null;
        if (secondaryDescriptor instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor iSecondaryDescriptor = (IndexedPropertyDescriptor)secondaryDescriptor;
            readMethod = iSecondaryDescriptor.getReadMethod();
            writeMethod = iSecondaryDescriptor.getWriteMethod();
            indexedReadMethod = iSecondaryDescriptor.getIndexedReadMethod();
            indexedWriteMethod = iSecondaryDescriptor.getIndexedWriteMethod();
        }
        if (primaryDescriptor instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor iPrimaryDescriptor = (IndexedPropertyDescriptor)primaryDescriptor;
            Method tempMethod = iPrimaryDescriptor.getIndexedReadMethod();
            if (tempMethod != null) {
                indexedReadMethod = tempMethod;
            }
            if ((tempMethod = iPrimaryDescriptor.getIndexedWriteMethod()) != null) {
                indexedWriteMethod = tempMethod;
            }
        }
        try {
            IndexedPropertyDescriptor mergedIndexedDescriptor = new IndexedPropertyDescriptor(primaryDescriptor.getName(), readMethod, writeMethod, indexedReadMethod, indexedWriteMethod);
            JavaIntrospector._mergePropertyDescriptors(secondaryDescriptor, primaryDescriptor, mergedIndexedDescriptor);
            return mergedIndexedDescriptor;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PropertyDescriptor _createMergedPropertyDescriptor(PropertyDescriptor secondaryDescriptor, PropertyDescriptor primaryDescriptor) {
        try {
            PropertyDescriptor mergedDescriptor = new PropertyDescriptor(primaryDescriptor.getName(), JavaIntrospector._getMergedReadMethod(secondaryDescriptor, primaryDescriptor), JavaIntrospector._getMergedWriteMethod(secondaryDescriptor, primaryDescriptor));
            JavaIntrospector._mergePropertyDescriptors(secondaryDescriptor, primaryDescriptor, mergedDescriptor);
            return mergedDescriptor;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodDescriptor _createMergedMethodDescriptor(MethodDescriptor secondaryDescriptor, MethodDescriptor primaryDescriptor) {
        ParameterDescriptor[] parameterDescriptors = primaryDescriptor.getParameterDescriptors();
        if (parameterDescriptors == null) {
            parameterDescriptors = secondaryDescriptor.getParameterDescriptors();
        }
        MethodDescriptor mergedDescriptor = new MethodDescriptor(primaryDescriptor.getMethod(), parameterDescriptors);
        JavaIntrospector._mergeFeatureDescriptors(secondaryDescriptor, primaryDescriptor, mergedDescriptor);
        return mergedDescriptor;
    }

    static EventSetDescriptor __createMergedEventSetStub(EventSetDescriptor oldDescriptor, MethodDescriptor[] listenerDescriptors) {
        try {
            EventSetDescriptor stubDescriptor = new EventSetDescriptor(oldDescriptor.getName(), oldDescriptor.getListenerType(), listenerDescriptors, oldDescriptor.getAddListenerMethod(), oldDescriptor.getRemoveListenerMethod());
            stubDescriptor.setUnicast(oldDescriptor.isUnicast());
            return stubDescriptor;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static EventSetDescriptor _createMergedEventSetDescriptor(EventSetDescriptor secondaryDescriptor, EventSetDescriptor primaryDescriptor) {
        MethodDescriptor[] listenerDescriptors = primaryDescriptor.getListenerMethodDescriptors();
        if (listenerDescriptors == null) {
            listenerDescriptors = secondaryDescriptor.getListenerMethodDescriptors();
        }
        EventSetDescriptor mergedDescriptor = JavaIntrospector.__createMergedEventSetStub(primaryDescriptor, listenerDescriptors);
        mergedDescriptor.setInDefaultEventSet(primaryDescriptor.isInDefaultEventSet() && secondaryDescriptor.isInDefaultEventSet());
        JavaIntrospector._mergeFeatureDescriptors(secondaryDescriptor, primaryDescriptor, mergedDescriptor);
        return mergedDescriptor;
    }

    private static Method _getMergedReadMethod(PropertyDescriptor secondaryDescriptor, PropertyDescriptor primaryDescriptor) {
        Method primaryReadMethod = primaryDescriptor.getReadMethod();
        Method secondaryReadMethod = secondaryDescriptor.getReadMethod();
        Method readMethod = primaryReadMethod;
        if (readMethod == null) {
            readMethod = secondaryReadMethod;
        } else if (secondaryReadMethod != null && secondaryReadMethod.getDeclaringClass() == primaryReadMethod.getDeclaringClass() && secondaryReadMethod.getReturnType() == Boolean.TYPE && primaryReadMethod.getReturnType() == Boolean.TYPE && primaryReadMethod.getName().startsWith(_READ_PREFIX)) {
            for (int i = 0; i < _BOOLEAN_READ_PREFIXES.length; ++i) {
                String currPrefix = _BOOLEAN_READ_PREFIXES[i];
                if (!secondaryReadMethod.getName().startsWith(currPrefix)) continue;
                readMethod = secondaryReadMethod;
                break;
            }
        }
        return readMethod;
    }

    private static Method _getMergedWriteMethod(PropertyDescriptor secondaryDescriptor, PropertyDescriptor primaryDescriptor) {
        Method writeMethod = primaryDescriptor.getWriteMethod();
        if (writeMethod == null) {
            writeMethod = secondaryDescriptor.getWriteMethod();
        }
        return writeMethod;
    }

    private static void _mergePropertyDescriptors(PropertyDescriptor secondaryDescriptor, PropertyDescriptor primaryDescriptor, PropertyDescriptor mergedDescriptor) {
        JavaIntrospector._mergeFeatureDescriptors(secondaryDescriptor, primaryDescriptor, mergedDescriptor);
        Class<?> editorClass = primaryDescriptor.getPropertyEditorClass();
        if (editorClass == null) {
            editorClass = secondaryDescriptor.getPropertyEditorClass();
        }
        mergedDescriptor.setPropertyEditorClass(editorClass);
        mergedDescriptor.setBound(secondaryDescriptor.isBound() | primaryDescriptor.isBound());
        mergedDescriptor.setConstrained(secondaryDescriptor.isConstrained() | primaryDescriptor.isConstrained());
    }

    private static void _mergeFeatureDescriptors(FeatureDescriptor secondaryDescriptor, FeatureDescriptor primaryDescriptor, FeatureDescriptor mergedDescriptor) {
        mergedDescriptor.setExpert(secondaryDescriptor.isExpert() | primaryDescriptor.isExpert());
        mergedDescriptor.setHidden(secondaryDescriptor.isHidden() | primaryDescriptor.isHidden());
        mergedDescriptor.setName(primaryDescriptor.getName());
        String shortDescription = primaryDescriptor.getShortDescription();
        if (shortDescription == null) {
            shortDescription = primaryDescriptor.getShortDescription();
        }
        mergedDescriptor.setShortDescription(shortDescription);
        String displayName = primaryDescriptor.getDisplayName();
        if (displayName == null) {
            displayName = primaryDescriptor.getDisplayName();
        }
        mergedDescriptor.setDisplayName(displayName);
        JavaIntrospector.__addFeatureValues(secondaryDescriptor, mergedDescriptor);
        JavaIntrospector.__addFeatureValues(primaryDescriptor, mergedDescriptor);
    }

    static void __addFeatureValues(FeatureDescriptor addingDescriptor, FeatureDescriptor destinationDescriptor) {
        Enumeration<String> keys = addingDescriptor.attributeNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object value = addingDescriptor.getValue(key);
                destinationDescriptor.setValue(key, value);
            }
        }
    }
}

