/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.validator;

import java.util.Date;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidad.validator.ValidatorUtils;

public class DateTimeRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "org.apache.myfaces.trinidad.DateTimeRange";
    public static final String MAXIMUM_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DateTimeRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DateTimeRangeValidator.MINIMUM";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "org.apache.myfaces.trinidad.validator.DateTimeRangeValidator.NOT_IN_RANGE";
    private static final FacesBean.Type _TYPE = new FacesBean.Type();
    private static final PropertyKey _MINIMUM_KEY = _TYPE.registerKey("minimum", Date.class);
    private static final PropertyKey _MAXIMUM_KEY = _TYPE.registerKey("maximum", Date.class);
    private static final PropertyKey _MAXIMUM_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailMaximum", String.class);
    private static final PropertyKey _MINIMUM_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailMinimum", String.class);
    private static final PropertyKey _NOT_IN_RANGE_MESSAGE_DETAIL_KEY = _TYPE.registerKey("messageDetailNotInRange", String.class);
    private static final PropertyKey _HINT_MAXIMUM_KEY = _TYPE.registerKey("hintMaximum", String.class);
    private static final PropertyKey _HINT_MINIMUM_KEY = _TYPE.registerKey("hintMinimum", String.class);
    private static final PropertyKey _HINT_NOT_IN_RANGE = _TYPE.registerKey("hintNotInRange", String.class);
    private static final PropertyKey _DISABLED_KEY = _TYPE.registerKey("disabled", Boolean.class, Boolean.FALSE);
    private FacesBean _facesBean = ValidatorUtils.getFacesBean(_TYPE);
    private boolean _transientValue = false;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DateTimeRangeValidator.class);

    public DateTimeRangeValidator() {
    }

    public DateTimeRangeValidator(Date maximum) {
        this.setMaximum(maximum);
    }

    public DateTimeRangeValidator(Date maximum, Date minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public Date getMaximum() {
        Object maxDate = this._facesBean.getProperty(_MAXIMUM_KEY);
        return ComponentUtils.resolveDate(maxDate);
    }

    public void setMaximum(Date maximum) {
        this._facesBean.setProperty(_MAXIMUM_KEY, maximum);
    }

    public Date getMinimum() {
        Object minDate = this._facesBean.getProperty(_MINIMUM_KEY);
        return ComponentUtils.resolveDate(minDate);
    }

    public void setMinimum(Date minimum) {
        this._facesBean.setProperty(_MINIMUM_KEY, minimum);
    }

    public void setMessageDetailMaximum(String maximumMessageDetail) {
        this._facesBean.setProperty(_MAXIMUM_MESSAGE_DETAIL_KEY, maximumMessageDetail);
    }

    public String getMessageDetailMaximum() {
        Object maxMsgDet = this._facesBean.getProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(maxMsgDet);
    }

    public void setMessageDetailMinimum(String minimumMessageDetail) {
        this._facesBean.setProperty(_MINIMUM_MESSAGE_DETAIL_KEY, minimumMessageDetail);
    }

    public String getMessageDetailMinimum() {
        Object minMsgDet = this._facesBean.getProperty(_MINIMUM_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(minMsgDet);
    }

    public void setMessageDetailNotInRange(String notInRangeMessageDetail) {
        this._facesBean.setProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY, notInRangeMessageDetail);
    }

    public String getMessageDetailNotInRange() {
        Object notInRngMsg = this._facesBean.getProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY);
        return ComponentUtils.resolveString(notInRngMsg);
    }

    public void setHintMaximum(String hintMaximum) {
        this._facesBean.setProperty(_HINT_MAXIMUM_KEY, hintMaximum);
    }

    public String getHintMaximum() {
        Object obj = this._facesBean.getProperty(_HINT_MAXIMUM_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintMinimum(String hintMinimum) {
        this._facesBean.setProperty(_HINT_MINIMUM_KEY, hintMinimum);
    }

    public String getHintMinimum() {
        Object obj = this._facesBean.getProperty(_HINT_MINIMUM_KEY);
        return ComponentUtils.resolveString(obj);
    }

    public void setHintNotInRange(String hintNotInRange) {
        this._facesBean.setProperty(_HINT_NOT_IN_RANGE, hintNotInRange);
    }

    public String getHintNotInRange() {
        Object obj = this._facesBean.getProperty(_HINT_NOT_IN_RANGE);
        return ComponentUtils.resolveString(obj);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (this.isDisabled()) {
            return;
        }
        if (context == null || component == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_FACESCONTEXT_OR_UICOMPONENT"));
        }
        if (value != null) {
            Date converted = DateTimeRangeValidator._getDateValue(value);
            Date max = this.getMaximum();
            Date min = this.getMinimum();
            if (max != null && converted.after(max)) {
                if (min != null) {
                    throw new ValidatorException(this._getNotInRangeMessage(context, component, value, min, max));
                }
                throw new ValidatorException(this._getMaximumMessage(context, component, value, max));
            }
            if (min != null && converted.before(min)) {
                if (max != null) {
                    throw new ValidatorException(this._getNotInRangeMessage(context, component, value, min, max));
                }
                FacesMessage msg = this._getMinimumMessage(context, component, value, min);
                throw new ValidatorException(msg);
            }
        }
    }

    public Object saveState(FacesContext context) {
        return this._facesBean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._facesBean.restoreState(context, state);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        ValidatorUtils.setValueExpression(this._facesBean, name, expression);
    }

    public ValueExpression getValueExpression(String name) {
        return ValidatorUtils.getValueExpression(this._facesBean, name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        ValidatorUtils.setValueBinding(this._facesBean, name, binding);
    }

    public ValueBinding getValueBinding(String name) {
        return ValidatorUtils.getValueBinding(this._facesBean, name);
    }

    public boolean equals(Object o) {
        if (o instanceof DateTimeRangeValidator) {
            DateTimeRangeValidator that = (DateTimeRangeValidator)o;
            if (this._transientValue == that._transientValue && this.isDisabled() == that.isDisabled() && ValidatorUtils.equals(this.getMinimum(), that.getMinimum()) && ValidatorUtils.equals(this.getMaximum(), that.getMaximum()) && ValidatorUtils.equals(this.getMessageDetailMaximum(), that.getMessageDetailMaximum()) && ValidatorUtils.equals(this.getMessageDetailMinimum(), that.getMessageDetailMinimum()) && ValidatorUtils.equals(this.getMessageDetailNotInRange(), that.getMessageDetailNotInRange())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        Date max = this.getMaximum();
        Date min = this.getMinimum();
        String maxMsgDet = this.getMessageDetailMaximum();
        String minMsgDet = this.getMessageDetailMinimum();
        String notInRangeMsgDet = this.getMessageDetailNotInRange();
        result = 37 * result + (max == null ? 0 : ((Object)max).hashCode());
        result = 37 * result + (min == null ? 0 : ((Object)min).hashCode());
        result = 37 * result + (this._transientValue ? 0 : 1);
        result = 37 * result + (this.isDisabled() ? 1 : 0);
        result = 37 * result + (maxMsgDet == null ? 0 : maxMsgDet.hashCode());
        result = 37 * result + (minMsgDet == null ? 0 : minMsgDet.hashCode());
        result = 37 * result + (notInRangeMsgDet == null ? 0 : notInRangeMsgDet.hashCode());
        return result;
    }

    public boolean isTransient() {
        return this._transientValue;
    }

    public void setTransient(boolean transientValue) {
        this._transientValue = transientValue;
    }

    public void setDisabled(boolean isDisabled) {
        this._facesBean.setProperty(_DISABLED_KEY, isDisabled);
    }

    public boolean isDisabled() {
        Boolean disabled = (Boolean)this._facesBean.getProperty(_DISABLED_KEY);
        return disabled != null ? disabled : false;
    }

    private static Date _getDateValue(Object value) throws IllegalArgumentException {
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException(_LOG.getMessage("VALUE_IS_NOT_DATE_TYPE"));
    }

    private FacesMessage _getNotInRangeMessage(FacesContext context, UIComponent component, Object value, Object min, Object max) {
        Converter converter = this._getConverter(context, component);
        Object cValue = this._getConvertedValue(context, component, converter, value);
        Object cMin = this._getConvertedValue(context, component, converter, min);
        Object cMax = this._getConvertedValue(context, component, converter, max);
        Object msg = this._getRawNotInRangeMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, cValue, cMin, cMax};
        return MessageFactory.getMessage(context, NOT_IN_RANGE_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawNotInRangeMessageDetail() {
        return this._facesBean.getRawProperty(_NOT_IN_RANGE_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getMaximumMessage(FacesContext context, UIComponent component, Object value, Object max) {
        Converter converter = this._getConverter(context, component);
        Object cValue = this._getConvertedValue(context, component, converter, value);
        Object cMax = this._getConvertedValue(context, component, converter, max);
        Object msg = this._getRawMaximumMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, cValue, cMax};
        return MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawMaximumMessageDetail() {
        return this._facesBean.getRawProperty(_MAXIMUM_MESSAGE_DETAIL_KEY);
    }

    private FacesMessage _getMinimumMessage(FacesContext context, UIComponent component, Object value, Object min) {
        Converter converter = this._getConverter(context, component);
        Object cValue = this._getConvertedValue(context, component, converter, value);
        Object cMin = this._getConvertedValue(context, component, converter, min);
        Object msg = this._getRawMinimumMessageDetail();
        Object label = ValidatorUtils.getComponentLabel(component);
        Object[] params = new Object[]{label, cValue, cMin};
        return MessageFactory.getMessage(context, MINIMUM_MESSAGE_ID, msg, params, component);
    }

    private Object _getRawMinimumMessageDetail() {
        return this._facesBean.getRawProperty(_MINIMUM_MESSAGE_DETAIL_KEY);
    }

    private Converter _getConverter(FacesContext context, UIComponent component) {
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            converter = context.getApplication().createConverter("javax.faces.DateTime");
        }
        assert (converter != null);
        return converter;
    }

    private Object _getConvertedValue(FacesContext context, UIComponent component, Converter converter, Object value) {
        return converter.getAsString(context, component, value);
    }
}

