/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class QueryParams {
    private static final String _URL_PARAM_SEPERATOR = "&";
    private static final String _URL_NAME_VALUE_PAIR_SEPERATOR = "=";

    public static QueryParams parseQueryString(String queryString, String encoding) throws UnsupportedEncodingException {
        return queryString == null || queryString.length() == 0 ? EmptyQueryParams.getInstance() : new NonEmptyQueryParams(QueryParams._parseNonEmptyQueryString(queryString, encoding));
    }

    public abstract Map<String, String> getParameterMap();

    public abstract Map<String, String[]> getParameterValuesMap();

    private static Map<String, String[]> _parseNonEmptyQueryString(String queryString, String encoding) throws UnsupportedEncodingException {
        String[] nameValuePairs;
        assert (queryString != null);
        assert (queryString.length() > 0);
        HashMap<String, String[]> parameterValuesMap = new HashMap<String, String[]>();
        for (String nameValuePair : nameValuePairs = queryString.split(_URL_PARAM_SEPERATOR)) {
            String[] nameAndValue = nameValuePair.split(_URL_NAME_VALUE_PAIR_SEPERATOR);
            String paramName = QueryParams._decodeParamName(nameAndValue, encoding);
            String paramValue = QueryParams._decodeParamValue(nameAndValue, encoding);
            QueryParams.__addParameterToMap(parameterValuesMap, paramName, paramValue);
        }
        return parameterValuesMap;
    }

    static void __addParameterToMap(Map<String, String[]> map, String name, String value) {
        String[] newValues;
        String[] oldValues = map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            ArrayList<String> newValuesList = new ArrayList<String>(Arrays.asList(oldValues));
            newValuesList.add(value);
            newValues = newValuesList.toArray(new String[oldValues.length + 1]);
        }
        map.put(name, newValues);
    }

    private static String _decodeParamName(String[] nameAndValue, String encoding) throws UnsupportedEncodingException {
        assert (nameAndValue.length > 0);
        return URLDecoder.decode(nameAndValue[0], encoding);
    }

    private static String _decodeParamValue(String[] nameAndValue, String encoding) throws UnsupportedEncodingException {
        return nameAndValue.length > 1 ? URLDecoder.decode(nameAndValue[1], encoding) : "";
    }

    private QueryParams() {
    }

    private static class EmptyQueryParams
    extends QueryParams {
        private static final QueryParams _INSTANCE = new EmptyQueryParams();

        public static QueryParams getInstance() {
            return _INSTANCE;
        }

        @Override
        public Map<String, String> getParameterMap() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String[]> getParameterValuesMap() {
            return Collections.emptyMap();
        }

        private EmptyQueryParams() {
        }
    }

    private static final class NonEmptyQueryParams
    extends QueryParams {
        private final Map<String, String[]> _parameterValuesMap;
        private final Map<String, String> _parameterMap;

        public NonEmptyQueryParams(Map<String, String[]> parameterValuesMap) {
            this._parameterValuesMap = Collections.unmodifiableMap(parameterValuesMap);
            this._parameterMap = NonEmptyQueryParams._toSingleValueParameterMap(parameterValuesMap);
        }

        @Override
        public Map<String, String> getParameterMap() {
            return this._parameterMap;
        }

        @Override
        public Map<String, String[]> getParameterValuesMap() {
            return this._parameterValuesMap;
        }

        private static final Map<String, String> _toSingleValueParameterMap(Map<String, String[]> parameterValuesMap) {
            HashMap<String, String> singleValueMap = new HashMap<String, String>();
            for (Map.Entry<String, String[]> multiValueParam : parameterValuesMap.entrySet()) {
                String[] multiValue = multiValueParam.getValue();
                assert (multiValue != null);
                assert (multiValue.length > 0);
                singleValueMap.put(multiValueParam.getKey(), multiValue[0]);
            }
            return Collections.unmodifiableMap(singleValueMap);
        }
    }
}

