/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.nifi.minifi.commons.schema.ProcessGroupSchema;
import org.apache.nifi.minifi.commons.schema.RemotePortSchema;
import org.apache.nifi.minifi.commons.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithId;

public class ParentGroupIdResolver {
    private final Map<String, String> processorIdToParentIdMap;
    private final Map<String, String> inputPortIdToParentIdMap;
    private final Map<String, String> outputPortIdToParentIdMap;
    private final Map<String, String> funnelIdToParentIdMap;
    private final Map<String, String> remoteInputPortIdToParentIdMap;
    private final Map<String, String> remoteOutputPortIdToParentIdMap;

    public ParentGroupIdResolver(ProcessGroupSchema processGroupSchema) {
        this.processorIdToParentIdMap = ParentGroupIdResolver.getParentIdMap(processGroupSchema, ProcessGroupSchema::getProcessors);
        this.inputPortIdToParentIdMap = ParentGroupIdResolver.getParentIdMap(processGroupSchema, ProcessGroupSchema::getInputPortSchemas);
        this.outputPortIdToParentIdMap = ParentGroupIdResolver.getParentIdMap(processGroupSchema, ProcessGroupSchema::getOutputPortSchemas);
        this.funnelIdToParentIdMap = ParentGroupIdResolver.getParentIdMap(processGroupSchema, ProcessGroupSchema::getFunnels);
        this.remoteInputPortIdToParentIdMap = ParentGroupIdResolver.getRemotePortParentIdMap(processGroupSchema, RemoteProcessGroupSchema::getInputPorts);
        this.remoteOutputPortIdToParentIdMap = ParentGroupIdResolver.getRemotePortParentIdMap(processGroupSchema, RemoteProcessGroupSchema::getOutputPorts);
    }

    protected static Map<String, String> getParentIdMap(ProcessGroupSchema processGroupSchema, Function<ProcessGroupSchema, Collection<? extends BaseSchemaWithId>> schemaAccessor) {
        HashMap<String, String> map = new HashMap<String, String>();
        ParentGroupIdResolver.getParentIdMap(processGroupSchema, map, schemaAccessor);
        return map;
    }

    protected static void getParentIdMap(ProcessGroupSchema processGroupSchema, Map<String, String> output, Function<ProcessGroupSchema, Collection<? extends BaseSchemaWithId>> schemaAccessor) {
        schemaAccessor.apply(processGroupSchema).forEach(p -> output.put(p.getId(), processGroupSchema.getId()));
        processGroupSchema.getProcessGroupSchemas().forEach(p -> ParentGroupIdResolver.getParentIdMap(p, output, schemaAccessor));
    }

    protected static Map<String, String> getRemotePortParentIdMap(ProcessGroupSchema processGroupSchema, Function<RemoteProcessGroupSchema, List<RemotePortSchema>> getPortsFunction) {
        HashMap<String, String> result = new HashMap<String, String>();
        ParentGroupIdResolver.getRemotePortParentIdMap(processGroupSchema, result, getPortsFunction);
        return result;
    }

    protected static void getRemotePortParentIdMap(ProcessGroupSchema processGroupSchema, Map<String, String> output, Function<RemoteProcessGroupSchema, List<RemotePortSchema>> getPortsFunction) {
        for (RemoteProcessGroupSchema remoteProcessGroupSchema : processGroupSchema.getRemoteProcessGroups()) {
            for (RemotePortSchema remotePortSchema : getPortsFunction.apply(remoteProcessGroupSchema)) {
                output.put(remotePortSchema.getId(), remoteProcessGroupSchema.getId());
            }
        }
        processGroupSchema.getProcessGroupSchemas().forEach(p -> ParentGroupIdResolver.getRemotePortParentIdMap(p, output, getPortsFunction));
    }

    public String getRemoteInputPortParentId(String id) {
        return this.remoteInputPortIdToParentIdMap.get(id);
    }

    public String getRemoteOutputPortParentId(String id) {
        return this.remoteOutputPortIdToParentIdMap.get(id);
    }

    public String getInputPortParentId(String id) {
        return this.inputPortIdToParentIdMap.get(id);
    }

    public String getOutputPortParentId(String id) {
        return this.outputPortIdToParentIdMap.get(id);
    }

    public String getProcessorParentId(String id) {
        return this.processorIdToParentIdMap.get(id);
    }

    public String getFunnelParentId(String id) {
        return this.funnelIdToParentIdMap.get(id);
    }
}

