/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.security.util.crypto.AbstractSecureHasher;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Argon2SecureHasher
extends AbstractSecureHasher {
    private static final Logger logger = LoggerFactory.getLogger(Argon2SecureHasher.class);
    private static final int DEFAULT_HASH_LENGTH = 32;
    public static final int DEFAULT_PARALLELISM = 8;
    public static final int DEFAULT_MEMORY = 65536;
    public static final int DEFAULT_ITERATIONS = 5;
    private static final int DEFAULT_SALT_LENGTH = 16;
    private static final int MIN_MEMORY_SIZE_KB = 8;
    private static final int MIN_PARALLELISM = 1;
    private static final int MAX_PARALLELISM = Double.valueOf(Math.pow(2.0, 24.0)).intValue() - 1;
    private static final int MIN_HASH_LENGTH = 4;
    private static final int MIN_ITERATIONS = 1;
    private static final int MIN_SALT_LENGTH = 8;
    private final Integer hashLength;
    private final Integer memory;
    private final int parallelism;
    private final Integer iterations;

    public Argon2SecureHasher() {
        this(32, 65536, 8, 5, 0);
    }

    public Argon2SecureHasher(Integer hashLength) {
        this(hashLength, 65536, 8, 5, 0);
    }

    public Argon2SecureHasher(Integer hashLength, Integer memory, int parallelism, Integer iterations) {
        this(hashLength, memory, parallelism, iterations, 0);
    }

    public Argon2SecureHasher(Integer hashLength, Integer memory, int parallelism, Integer iterations, Integer saltLength) {
        this.validateParameters(hashLength, memory, parallelism, iterations, saltLength);
        this.hashLength = hashLength;
        this.memory = memory;
        this.parallelism = parallelism;
        this.iterations = iterations;
        this.saltLength = saltLength;
    }

    private void validateParameters(Integer hashLength, Integer memory, int parallelism, Integer iterations, Integer saltLength) {
        if (!Argon2SecureHasher.isHashLengthValid(hashLength)) {
            logger.error("The provided hash length {} is outside the boundary of 4 to 2^32 - 1.", (Object)hashLength);
            throw new IllegalArgumentException("Invalid hash length is not within the hashLength boundary.");
        }
        if (!Argon2SecureHasher.isMemorySizeValid(memory)) {
            logger.error("The provided memory size {} KiB is outside the boundary of 8p to 2^32 - 1.", (Object)memory);
            throw new IllegalArgumentException("Invalid memory size is not within the memory boundary.");
        }
        if (!Argon2SecureHasher.isParallelismValid(parallelism)) {
            logger.error("The provided parallelization factor {} is outside the boundary of 1 to 2^24 - 1.", (Object)parallelism);
            throw new IllegalArgumentException("Invalid parallelization factor exceeds the parallelism boundary.");
        }
        if (!Argon2SecureHasher.isIterationsValid(iterations)) {
            logger.error("The iteration count {} is outside the boundary of 1 to 2^32 - 1.", (Object)iterations);
            throw new IllegalArgumentException("Invalid iteration count exceeds the iterations boundary.");
        }
        this.initializeSalt(saltLength);
    }

    @Override
    String getAlgorithmName() {
        return "Argon2";
    }

    @Override
    boolean acceptsEmptyInput() {
        return true;
    }

    public static boolean isHashLengthValid(Integer hashLength) {
        return hashLength >= 4 && hashLength <= UPPER_BOUNDARY;
    }

    public static boolean isMemorySizeValid(Integer memory) {
        if (memory < 65536) {
            logger.warn("The provided memory size {} KiB is below the recommended minimum {} KiB.", (Object)memory, (Object)65536);
        }
        return memory >= 8 && memory <= UPPER_BOUNDARY;
    }

    public static boolean isParallelismValid(int parallelism) {
        if (parallelism < 8) {
            logger.warn("The provided parallelization factor {} is below the recommended minimum {}.", (Object)parallelism, (Object)8);
        }
        return parallelism >= 1 && parallelism <= MAX_PARALLELISM;
    }

    public static boolean isIterationsValid(Integer iterations) {
        if (iterations < 5) {
            logger.warn("The provided iteration count {} is below the recommended minimum {}.", (Object)iterations, (Object)5);
        }
        return iterations >= 1 && iterations <= UPPER_BOUNDARY;
    }

    @Override
    int getDefaultSaltLength() {
        return 16;
    }

    @Override
    int getMinSaltLength() {
        return 8;
    }

    @Override
    int getMaxSaltLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    byte[] hash(byte[] input) {
        byte[] rawSalt = this.getSalt();
        return this.hash(input, rawSalt);
    }

    @Override
    byte[] hash(byte[] input, byte[] rawSalt) {
        logger.debug("Creating {} byte Argon2 hash with salt [{}]", (Object)this.hashLength, (Object)Hex.toHexString((byte[])rawSalt));
        if (!this.isSaltLengthValid(rawSalt.length)) {
            throw new IllegalArgumentException("The salt length (" + rawSalt.length + " bytes) is invalid");
        }
        byte[] hash = new byte[this.hashLength.intValue()];
        long startNanos = System.nanoTime();
        Argon2Parameters params = new Argon2Parameters.Builder(2).withSalt(rawSalt).withParallelism(this.parallelism).withMemoryAsKB(this.memory.intValue()).withIterations(this.iterations.intValue()).build();
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(params);
        long initNanos = System.nanoTime();
        generator.generateBytes(input, hash);
        long generateNanos = System.nanoTime();
        long initDurationMicros = TimeUnit.NANOSECONDS.toMicros(initNanos - startNanos);
        long generateDurationMicros = TimeUnit.NANOSECONDS.toMicros(generateNanos - initNanos);
        long totalDurationMillis = TimeUnit.MICROSECONDS.toMillis(initDurationMicros + generateDurationMicros);
        logger.debug("Generated Argon2 hash in {} ms (init: {} \u00b5s, generate: {} \u00b5s)", new Object[]{totalDurationMillis, initDurationMicros, generateDurationMicros});
        return hash;
    }
}

