/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Date;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.expression.AttributeExpression;

public class EqualsEvaluator
extends BooleanEvaluator {
    private final Evaluator<?> subject;
    private final Evaluator<?> compareTo;

    public EqualsEvaluator(Evaluator<?> subject, Evaluator<?> compareTo) {
        this.subject = subject;
        this.compareTo = compareTo;
    }

    @Override
    public QueryResult<Boolean> evaluate(EvaluationContext evaluationContext) {
        Object a = this.subject.evaluate(evaluationContext).getValue();
        if (a == null) {
            return new BooleanQueryResult(false);
        }
        Object b = this.compareTo.evaluate(evaluationContext).getValue();
        if (b == null) {
            return new BooleanQueryResult(false);
        }
        if (this.subject.getResultType() == this.compareTo.getResultType()) {
            return new BooleanQueryResult(a.equals(b));
        }
        String normalizedSubjectValue = this.normalizeValue(this.subject.getResultType(), a);
        if (normalizedSubjectValue == null) {
            return new BooleanQueryResult(false);
        }
        String normalizedCompareToValue = this.normalizeValue(this.compareTo.getResultType(), b);
        if (normalizedCompareToValue == null) {
            return new BooleanQueryResult(false);
        }
        return new BooleanQueryResult(normalizedSubjectValue.equals(normalizedCompareToValue));
    }

    private String normalizeValue(AttributeExpression.ResultType type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                return (String)value;
            }
            case DATE: {
                return String.valueOf(((Date)value).getTime());
            }
        }
        return String.valueOf(value);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

