/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.groups.DataValve;
import org.apache.nifi.groups.FlowFileGate;
import org.apache.nifi.groups.ProcessGroup;

public class SingleConcurrencyFlowFileGate
implements FlowFileGate {
    private final AtomicBoolean claimed = new AtomicBoolean(false);

    public boolean tryClaim(Port port) {
        boolean empty;
        boolean alreadyClaimed = this.claimed.getAndSet(true);
        if (alreadyClaimed) {
            return false;
        }
        ProcessGroup dataValveGroup = port.getProcessGroup().getParent();
        DataValve dataValve = dataValveGroup.getDataValve();
        boolean openFlowIntoGroup = dataValve.tryOpenFlowIntoGroup(port.getProcessGroup());
        if (!openFlowIntoGroup) {
            this.claimed.set(false);
            return false;
        }
        boolean bl = empty = !port.getProcessGroup().isDataQueued();
        if (empty) {
            return true;
        }
        dataValve.closeFlowIntoGroup(port.getProcessGroup());
        this.claimed.set(false);
        return false;
    }

    public void releaseClaim(Port port) {
        this.claimed.set(false);
        ProcessGroup dataValveGroup = port.getProcessGroup().getParent();
        DataValve dataValve = dataValveGroup.getDataValve();
        dataValve.closeFlowIntoGroup(port.getProcessGroup());
    }
}

