/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractTableNameRegistry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableToken;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.datetime.millitime.MillisecondClock;

public class TableNameRegistryRO
extends AbstractTableNameRegistry {
    private final long autoReloadTimeout;
    private final MillisecondClock clockMs;
    private volatile long lastReloadTimestampMs = 0L;
    private ConcurrentHashMap<TableToken> nameTableTokenMap = new ConcurrentHashMap(false);
    private ConcurrentHashMap<TableToken> nameTableTokenMap2 = new ConcurrentHashMap(false);
    private ConcurrentHashMap<ReverseTableMapItem> reverseTableNameTokenMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ReverseTableMapItem> reverseTableNameTokenMap2 = new ConcurrentHashMap();

    public TableNameRegistryRO(CairoConfiguration configuration) {
        super(configuration);
        this.clockMs = configuration.getMillisecondClock();
        long timeout = configuration.getTableRegistryAutoReloadFrequency();
        this.autoReloadTimeout = timeout > 0L ? timeout : Long.MAX_VALUE;
        this.setNameMaps(this.nameTableTokenMap, this.reverseTableNameTokenMap);
    }

    @Override
    public boolean dropTable(TableToken token) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public TableToken getTableToken(CharSequence tableName) {
        TableToken record = this.nameTableTokenMap.get(tableName);
        if (record == null && this.clockMs.getTicks() - this.lastReloadTimestampMs > this.autoReloadTimeout) {
            this.reloadTableNameCacheThrottled();
            return this.nameTableTokenMap.get(tableName);
        }
        return record;
    }

    @Override
    public TableToken lockTableName(String tableName, String dirName, int tableId, boolean isWal) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public void purgeToken(TableToken token) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public void registerName(TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public synchronized void reloadTableNameCache() {
        this.nameTableTokenMap2.clear();
        this.reverseTableNameTokenMap2.clear();
        this.nameStore.reload(this.nameTableTokenMap2, this.reverseTableNameTokenMap2);
        this.setNameMaps(this.nameTableTokenMap2, this.reverseTableNameTokenMap2);
        ConcurrentHashMap<TableToken> tmp = this.nameTableTokenMap2;
        this.nameTableTokenMap2 = this.nameTableTokenMap;
        this.nameTableTokenMap = tmp;
        ConcurrentHashMap<ReverseTableMapItem> tmp2 = this.reverseTableNameTokenMap2;
        this.reverseTableNameTokenMap2 = this.reverseTableNameTokenMap;
        this.reverseTableNameTokenMap = tmp2;
        this.lastReloadTimestampMs = this.clockMs.getTicks();
    }

    @Override
    public TableToken rename(CharSequence oldName, CharSequence newName, TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public void unlockTableName(TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    private synchronized void reloadTableNameCacheThrottled() {
        if (this.clockMs.getTicks() - this.lastReloadTimestampMs > this.autoReloadTimeout) {
            this.reloadTableNameCache();
        }
    }
}

