/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.wal.ApplyWal2TableJob;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.mp.WorkerPool;
import org.jetbrains.annotations.Nullable;

public class WalUtils {
    public static final int DROP_TABLE_STRUCTURE_VERSION = -2;
    public static final int DROP_TABLE_WALID = -2;
    public static final String EVENT_FILE_NAME = "_event";
    public static final int METADATA_WALID = -1;
    public static final String SEQ_DIR = "txn_seq";
    public static final String SEQ_DIR_DEPRECATED = "seq";
    public static final long SEQ_META_OFFSET_WAL_LENGTH = 0L;
    public static final long SEQ_META_OFFSET_WAL_VERSION = 4L;
    public static final long SEQ_META_OFFSET_STRUCTURE_VERSION = 8L;
    public static final long SEQ_META_OFFSET_COLUMN_COUNT = 16L;
    public static final long SEQ_META_OFFSET_TIMESTAMP_INDEX = 20L;
    public static final long SEQ_META_TABLE_ID = 24L;
    public static final long SEQ_META_SUSPENDED = 28L;
    public static final long SEQ_META_OFFSET_COLUMNS = 29L;
    public static final String TXNLOG_FILE_NAME = "_txnlog";
    public static final String TXNLOG_FILE_NAME_META_INX = "_txnlog.meta.i";
    public static final String TXNLOG_FILE_NAME_META_VAR = "_txnlog.meta.d";
    public static final int WALE_HEADER_SIZE = 12;
    public static final long WALE_SIZE_OFFSET = 0L;
    public static final int WAL_FORMAT_OFFSET = 8;
    public static final int WAL_FORMAT_VERSION = 0;
    public static final String WAL_INDEX_FILE_NAME = "_wal_index.d";
    public static final String WAL_NAME_BASE = "wal";
    public static final String TABLE_REGISTRY_NAME_FILE = "tables.d";

    public static void setupWorkerPool(WorkerPool workerPool, CairoEngine engine, int sharedWorkerCount, @Nullable FunctionFactoryCache ffCache) {
        int workerCount = workerPool.getWorkerCount();
        for (int i = 0; i < workerCount; ++i) {
            ApplyWal2TableJob applyWal2TableJob = new ApplyWal2TableJob(engine, workerCount, sharedWorkerCount, ffCache);
            workerPool.assign(applyWal2TableJob);
            workerPool.freeOnExit(applyWal2TableJob);
        }
    }
}

