/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SinDoubleFunctionFactory
implements FunctionFactory {
    public static final String SYMBOL = "sin";

    @Override
    public String getSignature() {
        return "sin(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new SinFunction(args.getQuick(0));
    }

    private static class SinFunction
    extends DoubleFunction
    implements ScalarFunction,
    UnaryFunction {
        final Function angleRad;

        public SinFunction(Function angleRad) {
            this.angleRad = angleRad;
        }

        @Override
        public Function getArg() {
            return this.angleRad;
        }

        @Override
        public double getDouble(Record rec) {
            return StrictMath.sin(this.angleRad.getDouble(rec));
        }

        @Override
        public String getName() {
            return SinDoubleFunctionFactory.SYMBOL;
        }
    }
}

