/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class ObjStack<T>
implements Mutable {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private T[] elements;
    private int head;
    private int mask;
    private int tail;

    public ObjStack() {
        this(16);
    }

    public ObjStack(int initialCapacity) {
        this.allocateElements(initialCapacity);
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            this.tail = 0;
            this.head = 0;
            Arrays.fill(this.elements, null);
        }
    }

    public boolean notEmpty() {
        return this.head != this.tail;
    }

    public T peek() {
        return this.elements[this.head];
    }

    public T peek(int n) {
        return this.elements[this.head + n & this.mask];
    }

    public T pop() {
        int h = this.head;
        T result = this.elements[h];
        if (result == null) {
            return null;
        }
        this.elements[h] = null;
        this.head = h + 1 & this.mask;
        return result;
    }

    public void push(T e) {
        this.head = this.head - 1 & this.mask;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public int size() {
        return this.tail - this.head & this.mask;
    }

    public void update(T e) {
        this.elements[this.head] = e;
    }

    private void allocateElements(int capacity) {
        capacity = capacity < 8 ? 8 : Numbers.ceilPow2(capacity);
        this.elements = new Object[capacity];
        this.mask = capacity - 1;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int h = this.head;
        int n = this.elements.length;
        int r = n - h;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Stack is too big");
        }
        Object[] next = new Object[newCapacity];
        System.arraycopy(this.elements, h, next, 0, r);
        System.arraycopy(this.elements, 0, next, r, h);
        Arrays.fill(next, r + h, newCapacity, null);
        this.elements = next;
        this.head = 0;
        this.tail = n;
        this.mask = newCapacity - 1;
    }
}

