/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.authorization;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.registry.authorization.Tenant;

@ApiModel
public class UserGroup
extends Tenant {
    private Set<Tenant> users;

    public UserGroup() {
    }

    public UserGroup(String identifier, String identity) {
        super(identifier, identity);
    }

    @ApiModelProperty(value="The users that belong to this user group. This can only be changed if this group is configurable.")
    public Set<Tenant> getUsers() {
        return this.users;
    }

    public void setUsers(Set<Tenant> users) {
        this.users = users;
    }

    public void addUsers(Collection<? extends Tenant> users) {
        if (users != null) {
            if (this.users == null) {
                this.users = new HashSet<Tenant>();
            }
            this.users.addAll(users);
        }
    }

    public void addUser(Tenant user) {
        if (user != null) {
            if (this.users == null) {
                this.users = new HashSet<Tenant>();
            }
            this.users.add(user);
        }
    }
}

