/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.xds.AutoValue_Stats_ClusterStats;
import io.grpc.xds.AutoValue_Stats_DroppedRequests;
import io.grpc.xds.AutoValue_Stats_UpstreamLocalityStats;
import io.grpc.xds.Locality;
import java.util.Map;
import javax.annotation.Nullable;

final class Stats {
    private Stats() {
    }

    static final class BackendLoadMetricStats {
        private long numRequestsFinishedWithMetric;
        private double totalMetricValue;

        BackendLoadMetricStats(long numRequestsFinishedWithMetric, double totalMetricValue) {
            this.numRequestsFinishedWithMetric = numRequestsFinishedWithMetric;
            this.totalMetricValue = totalMetricValue;
        }

        public long numRequestsFinishedWithMetric() {
            return this.numRequestsFinishedWithMetric;
        }

        public double totalMetricValue() {
            return this.totalMetricValue;
        }

        public void addMetricValueAndIncrementRequestsFinished(double metricValue) {
            ++this.numRequestsFinishedWithMetric;
            this.totalMetricValue += metricValue;
        }
    }

    @AutoValue
    static abstract class UpstreamLocalityStats {
        UpstreamLocalityStats() {
        }

        abstract Locality locality();

        abstract long totalIssuedRequests();

        abstract long totalSuccessfulRequests();

        abstract long totalErrorRequests();

        abstract long totalRequestsInProgress();

        abstract ImmutableMap<String, BackendLoadMetricStats> loadMetricStatsMap();

        static UpstreamLocalityStats create(Locality locality, long totalIssuedRequests, long totalSuccessfulRequests, long totalErrorRequests, long totalRequestsInProgress, Map<String, BackendLoadMetricStats> loadMetricStatsMap) {
            return new AutoValue_Stats_UpstreamLocalityStats(locality, totalIssuedRequests, totalSuccessfulRequests, totalErrorRequests, totalRequestsInProgress, (ImmutableMap<String, BackendLoadMetricStats>)ImmutableMap.copyOf(loadMetricStatsMap));
        }
    }

    @AutoValue
    static abstract class DroppedRequests {
        DroppedRequests() {
        }

        abstract String category();

        abstract long droppedCount();

        static DroppedRequests create(String category, long droppedCount) {
            return new AutoValue_Stats_DroppedRequests(category, droppedCount);
        }
    }

    @AutoValue
    static abstract class ClusterStats {
        ClusterStats() {
        }

        abstract String clusterName();

        @Nullable
        abstract String clusterServiceName();

        abstract ImmutableList<UpstreamLocalityStats> upstreamLocalityStatsList();

        abstract ImmutableList<DroppedRequests> droppedRequestsList();

        abstract long totalDroppedRequests();

        abstract long loadReportIntervalNano();

        static Builder newBuilder() {
            return new AutoValue_Stats_ClusterStats.Builder().totalDroppedRequests(0L).loadReportIntervalNano(0L);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder clusterName(String var1);

            abstract Builder clusterServiceName(String var1);

            abstract ImmutableList.Builder<UpstreamLocalityStats> upstreamLocalityStatsListBuilder();

            Builder addUpstreamLocalityStats(UpstreamLocalityStats upstreamLocalityStats) {
                this.upstreamLocalityStatsListBuilder().add((Object)upstreamLocalityStats);
                return this;
            }

            abstract ImmutableList.Builder<DroppedRequests> droppedRequestsListBuilder();

            Builder addDroppedRequests(DroppedRequests droppedRequests) {
                this.droppedRequestsListBuilder().add((Object)droppedRequests);
                return this;
            }

            abstract Builder totalDroppedRequests(long var1);

            abstract Builder loadReportIntervalNano(long var1);

            abstract long loadReportIntervalNano();

            abstract ClusterStats build();
        }
    }
}

