/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;

public abstract class EncodedSensitivePropertyProvider
implements SensitivePropertyProvider {
    private static final Charset VALUE_CHARACTER_SET = StandardCharsets.UTF_8;
    private static final Base64.Encoder ENCODER = Base64.getEncoder().withoutPadding();
    private static final Base64.Decoder DECODER = Base64.getDecoder();

    public String protect(String unprotectedValue, ProtectedPropertyContext context) {
        Objects.requireNonNull(unprotectedValue, "Value required");
        Objects.requireNonNull(context, "Context required");
        try {
            byte[] bytes = unprotectedValue.getBytes(VALUE_CHARACTER_SET);
            byte[] encrypted = this.getEncrypted(bytes);
            return ENCODER.encodeToString(encrypted);
        }
        catch (RuntimeException e) {
            String message = String.format("Property [%s] Encryption Failed", context.getContextKey());
            throw new SensitivePropertyProtectionException(message, (Throwable)e);
        }
    }

    public String unprotect(String protectedValue, ProtectedPropertyContext context) {
        Objects.requireNonNull(protectedValue, "Value required");
        Objects.requireNonNull(context, "Context required");
        try {
            byte[] decoded = DECODER.decode(protectedValue);
            byte[] decrypted = this.getDecrypted(decoded);
            return new String(decrypted, VALUE_CHARACTER_SET);
        }
        catch (RuntimeException e) {
            String message = String.format("Property [%s] Decryption Failed", context.getContextKey());
            throw new SensitivePropertyProtectionException(message, (Throwable)e);
        }
    }

    protected abstract byte[] getEncrypted(byte[] var1);

    protected abstract byte[] getDecrypted(byte[] var1);
}

