/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties.configuration;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.configuration.AzureClientProvider;

public class AzureSecretClientProvider
extends AzureClientProvider<SecretClient> {
    protected static final String URI_PROPERTY = "azure.keyvault.uri";
    private static final Set<String> REQUIRED_PROPERTY_NAMES = new HashSet<String>(Collections.singletonList("azure.keyvault.uri"));

    protected SecretClient getConfiguredClient(Properties clientProperties) {
        String uri = clientProperties.getProperty(URI_PROPERTY);
        this.logger.debug("Azure Secret Client with URI [{}]", (Object)uri);
        try {
            DefaultAzureCredential credential = new DefaultAzureCredentialBuilder().build();
            return new SecretClientBuilder().credential((TokenCredential)credential).vaultUrl(uri).buildClient();
        }
        catch (RuntimeException e) {
            throw new SensitivePropertyProtectionException("Azure Secret Builder Client Failed using Default Credentials", (Throwable)e);
        }
    }

    protected Set<String> getRequiredPropertyNames() {
        return REQUIRED_PROPERTY_NAMES;
    }
}

