/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.endpoints;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AccountIdEndpointMode;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkInternalApi
public final class AccountIdEndpointModeResolver {
    private static final AccountIdEndpointMode SDK_DEFAULT_MODE = AccountIdEndpointMode.PREFERRED;
    private Supplier<ProfileFile> profileFile;
    private String profileName;
    private AccountIdEndpointMode defaultMode;

    private AccountIdEndpointModeResolver() {
    }

    public static AccountIdEndpointModeResolver create() {
        return new AccountIdEndpointModeResolver();
    }

    public AccountIdEndpointModeResolver profileFile(Supplier<ProfileFile> profileFile) {
        this.profileFile = profileFile;
        return this;
    }

    public AccountIdEndpointModeResolver profileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public AccountIdEndpointModeResolver defaultMode(AccountIdEndpointMode defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    public AccountIdEndpointMode resolve() {
        return OptionalUtils.firstPresent(this.fromSystemSettings(), (Supplier[])new Supplier[]{() -> this.fromProfileFile(this.profileFile, this.profileName)}).orElseGet(this::fromDefaultMode);
    }

    private Optional<AccountIdEndpointMode> fromSystemSettings() {
        return SdkSystemSetting.AWS_ACCOUNT_ID_ENDPOINT_MODE.getStringValue().flatMap(this::stringToEnum);
    }

    private Optional<AccountIdEndpointMode> fromProfileFile(Supplier<ProfileFile> profileFile, String profileName) {
        return profileFile.get().profile(profileName).flatMap(p -> p.property("account_id_endpoint_mode")).flatMap(this::stringToEnum);
    }

    private AccountIdEndpointMode fromDefaultMode() {
        return this.defaultMode != null ? this.defaultMode : SDK_DEFAULT_MODE;
    }

    private Optional<AccountIdEndpointMode> stringToEnum(String value) {
        return Optional.of(AccountIdEndpointMode.fromValue(value));
    }
}

