/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.jetty.connector;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.jetty.configuration.connector.ApplicationLayerProtocol;
import org.apache.nifi.jetty.configuration.connector.StandardServerConnectorFactory;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.util.TlsPlatform;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ApplicationServerConnectorFactory
extends StandardServerConnectorFactory {
    private static final int HEADER_SIZE = 16384;
    private static final String CIPHER_SUITE_SEPARATOR_PATTERN = ",\\s*";
    private static final String DEFAULT_HOST = null;
    private final String includeCipherSuites;
    private final String excludeCipherSuites;
    private final String host;
    private SslContextFactory.Server sslContextFactory;

    public ApplicationServerConnectorFactory(Server server, NiFiRegistryProperties properties) {
        super(server, ApplicationServerConnectorFactory.getPort(properties));
        this.host = ApplicationServerConnectorFactory.getHost(properties);
        this.includeCipherSuites = properties.getHttpsCipherSuitesInclude();
        this.excludeCipherSuites = properties.getHttpsCipherSuitesExclude();
        if (properties.isHTTPSConfigured()) {
            if (properties.getNeedClientAuth()) {
                this.setNeedClientAuth(true);
            } else {
                this.setWantClientAuth(true);
            }
            SSLContext sslContext = this.buildSslContext(properties);
            this.setSslContext(sslContext);
            this.setApplicationLayerProtocols(properties);
            this.setIncludeSecurityProtocols(TlsPlatform.getPreferredProtocols().toArray(new String[0]));
        }
    }

    public ServerConnector getServerConnector() {
        ServerConnector serverConnector = super.getServerConnector();
        serverConnector.setHost(this.host);
        return serverConnector;
    }

    protected SslContextFactory.Server getSslContextFactory() {
        if (this.sslContextFactory == null) {
            String[] cipherSuites;
            this.sslContextFactory = super.getSslContextFactory();
            if (StringUtils.isNotBlank((CharSequence)this.includeCipherSuites)) {
                cipherSuites = this.getCipherSuites(this.includeCipherSuites);
                this.sslContextFactory.setIncludeCipherSuites(cipherSuites);
            }
            if (StringUtils.isNotBlank((CharSequence)this.excludeCipherSuites)) {
                cipherSuites = this.getCipherSuites(this.excludeCipherSuites);
                this.sslContextFactory.setExcludeCipherSuites(cipherSuites);
            }
        }
        return this.sslContextFactory;
    }

    protected HttpConfiguration getHttpConfiguration() {
        HttpConfiguration httpConfiguration = super.getHttpConfiguration();
        httpConfiguration.setRequestHeaderSize(16384);
        httpConfiguration.setResponseHeaderSize(16384);
        return httpConfiguration;
    }

    private String[] getCipherSuites(String cipherSuitesProperty) {
        return cipherSuitesProperty.split(CIPHER_SUITE_SEPARATOR_PATTERN);
    }

    private SSLContext buildSslContext(NiFiRegistryProperties properties) {
        KeyStore keyStore = this.buildKeyStore(properties);
        char[] keyPassword = this.getKeyPassword(properties);
        KeyStore trustStore = this.buildTrustStore(properties);
        return new StandardSslContextBuilder().keyStore(keyStore).keyPassword(keyPassword).trustStore(trustStore).build();
    }

    private char[] getKeyPassword(NiFiRegistryProperties properties) {
        String keyStorePassword = this.getRequiredProperty(properties, "nifi.registry.security.keystorePasswd");
        String keyPassword = properties.getProperty("nifi.registry.security.keyPasswd", keyStorePassword);
        return keyPassword.toCharArray();
    }

    private KeyStore buildKeyStore(NiFiRegistryProperties properties) {
        String keyStore = this.getRequiredProperty(properties, "nifi.registry.security.keystore");
        String keyStoreType = this.getRequiredProperty(properties, "nifi.registry.security.keystoreType");
        String keyStorePassword = this.getRequiredProperty(properties, "nifi.registry.security.keystorePasswd");
        return this.buildStore(keyStore, keyStoreType, keyStorePassword);
    }

    private KeyStore buildTrustStore(NiFiRegistryProperties properties) {
        String trustStore = this.getRequiredProperty(properties, "nifi.registry.security.truststore");
        String trustStoreType = this.getRequiredProperty(properties, "nifi.registry.security.truststoreType");
        String trustStorePassword = this.getRequiredProperty(properties, "nifi.registry.security.truststorePasswd");
        return this.buildStore(trustStore, trustStoreType, trustStorePassword);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore buildStore(String store, String storeType, String storePassword) {
        Path trustStorePath = Paths.get(store, new String[0]);
        try (InputStream inputStream = Files.newInputStream(trustStorePath, new OpenOption[0]);){
            KeyStore keyStore = new StandardKeyStoreBuilder().type(storeType).password(storePassword.toCharArray()).inputStream(inputStream).build();
            return keyStore;
        }
        catch (IOException e) {
            String message = String.format("Store Path [%s] read failed", store);
            throw new IllegalStateException(message, e);
        }
    }

    private String getRequiredProperty(NiFiRegistryProperties properties, String property) {
        String requiredProperty = properties.getProperty(property);
        if (requiredProperty == null || requiredProperty.isEmpty()) {
            throw new IllegalStateException(String.format("Required Property [%s] not configured", property));
        }
        return requiredProperty;
    }

    private void setApplicationLayerProtocols(NiFiRegistryProperties properties) {
        Set protocols = properties.getWebHttpsApplicationProtocols();
        Set applicationLayerProtocols = Arrays.stream(ApplicationLayerProtocol.values()).filter(applicationLayerProtocol -> protocols.contains(applicationLayerProtocol.getProtocol())).collect(Collectors.toSet());
        this.setApplicationLayerProtocols(applicationLayerProtocols);
    }

    private static String getHost(NiFiRegistryProperties properties) {
        String host = properties.isHTTPSConfigured() ? properties.getHttpsHost() : properties.getHttpHost();
        return (String)StringUtils.defaultIfEmpty((CharSequence)host, (CharSequence)DEFAULT_HOST);
    }

    private static int getPort(NiFiRegistryProperties properties) {
        Integer httpsPort = properties.getSslPort();
        Integer httpPort = properties.getPort();
        if (ObjectUtils.allNull((Object[])new Object[]{httpsPort, httpPort})) {
            throw new IllegalStateException("Invalid port configuration: Neither nifi.registry.web.https.port nor nifi.registry.web.http.port specified");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{httpsPort, httpPort})) {
            throw new IllegalStateException("Invalid port configuration: Both nifi.registry.web.https.port and nifi.registry.web.http.port specified");
        }
        return (Integer)ObjectUtils.defaultIfNull((Object)httpsPort, (Object)httpPort);
    }
}

