/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.PollingUtil;
import com.azure.core.util.polling.implementation.PollResult;
import com.azure.core.util.polling.implementation.PollingUtils;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class OperationResourcePollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(OperationResourcePollingStrategy.class);
    private static final HttpHeaderName DEFAULT_OPERATION_LOCATION_HEADER = HttpHeaderName.fromString("Operation-Location");
    private static final TypeReference<PollResult> POLL_RESULT_TYPE_REFERENCE = TypeReference.createInstance(PollResult.class);
    private final HttpPipeline httpPipeline;
    private final ObjectSerializer serializer;
    private final String endpoint;
    private final HttpHeaderName operationLocationHeaderName;
    private final Context context;
    private final String serviceVersion;

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline) {
        this(DEFAULT_OPERATION_LOCATION_HEADER, new PollingStrategyOptions(httpPipeline));
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer, String operationLocationHeaderName) {
        this(httpPipeline, serializer, operationLocationHeaderName, Context.NONE);
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer, String operationLocationHeaderName, Context context) {
        this(httpPipeline, null, serializer, operationLocationHeaderName, context);
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, String endpoint, ObjectSerializer serializer, String operationLocationHeaderName, Context context) {
        this(operationLocationHeaderName == null ? null : HttpHeaderName.fromString(operationLocationHeaderName), new PollingStrategyOptions(httpPipeline).setEndpoint(endpoint).setSerializer(serializer).setContext(context));
    }

    public OperationResourcePollingStrategy(HttpHeaderName operationLocationHeaderName, PollingStrategyOptions pollingStrategyOptions) {
        Objects.requireNonNull(pollingStrategyOptions, "'pollingStrategyOptions' cannot be null");
        this.httpPipeline = pollingStrategyOptions.getHttpPipeline();
        this.endpoint = pollingStrategyOptions.getEndpoint();
        this.serializer = pollingStrategyOptions.getSerializer() != null ? pollingStrategyOptions.getSerializer() : new DefaultJsonSerializer();
        this.operationLocationHeaderName = operationLocationHeaderName == null ? DEFAULT_OPERATION_LOCATION_HEADER : operationLocationHeaderName;
        this.serviceVersion = pollingStrategyOptions.getServiceVersion();
        this.context = pollingStrategyOptions.getContext() == null ? Context.NONE : pollingStrategyOptions.getContext();
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        return Mono.fromSupplier(() -> PollingUtil.operationResourceCanPoll(initialResponse, this.operationLocationHeaderName, this.endpoint, LOGGER));
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpHeader operationLocationHeader = response.getHeaders().get(this.operationLocationHeaderName);
        HttpHeader locationHeader = response.getHeaders().get(HttpHeaderName.LOCATION);
        if (operationLocationHeader != null) {
            pollingContext.setData(this.operationLocationHeaderName.getCaseSensitiveName(), PollingUtils.getAbsolutePath(operationLocationHeader.getValue(), this.endpoint, LOGGER));
        }
        if (locationHeader != null) {
            pollingContext.setData("Location", PollingUtils.getAbsolutePath(locationHeader.getValue(), this.endpoint, LOGGER));
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration retryAfter = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return PollingUtils.convertResponse(response.getValue(), this.serializer, pollResponseType).map(value -> new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, value, retryAfter)).switchIfEmpty(Mono.fromSupplier(() -> new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, null, retryAfter)));
        }
        return Mono.error((Throwable)new AzureException(String.format("Operation failed or cancelled with status code %d,, '%s' header: %s, and response body: %s", response.getStatusCode(), this.operationLocationHeaderName, operationLocationHeader, PollingUtils.serializeResponse(response.getValue(), this.serializer))));
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        String url = pollingContext.getData(this.operationLocationHeaderName.getCaseSensitiveName());
        url = this.setServiceVersionQueryParam(url);
        HttpRequest request = new HttpRequest(HttpMethod.GET, url);
        return FluxUtil.withContext(context1 -> this.httpPipeline.send(request, CoreUtils.mergeContexts(context1, this.context))).flatMap(response -> response.getBodyAsByteArray().map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, POLL_RESULT_TYPE_REFERENCE).map(pollResult -> {
            String resourceLocation = pollResult.getResourceLocation();
            if (resourceLocation != null) {
                pollingContext.setData("resourceLocation", PollingUtils.getAbsolutePath(resourceLocation, this.endpoint, LOGGER));
            }
            pollingContext.setData("pollResponseBody", binaryData.toString());
            return pollResult.getStatus();
        }).flatMap(status -> {
            Duration retryAfter = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return PollingUtils.deserializeResponse(binaryData, this.serializer, pollResponseType).map(value -> new PollResponse<Object>((LongRunningOperationStatus)status, value, retryAfter));
        })));
    }

    private String setServiceVersionQueryParam(String url) {
        if (!CoreUtils.isNullOrEmpty(this.serviceVersion)) {
            UrlBuilder urlBuilder = UrlBuilder.parse(url);
            urlBuilder.setQueryParameter("api-version", this.serviceVersion);
            url = urlBuilder.toString();
        }
        return url;
    }

    @Override
    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.error((Throwable)new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            return Mono.error((Throwable)new AzureException("Long running operation cancelled."));
        }
        String finalGetUrl = pollingContext.getData("resourceLocation");
        if (finalGetUrl == null) {
            String httpMethod = pollingContext.getData("httpMethod");
            if (HttpMethod.PUT.name().equalsIgnoreCase(httpMethod) || HttpMethod.PATCH.name().equalsIgnoreCase(httpMethod)) {
                finalGetUrl = pollingContext.getData("requestURL");
            } else if (HttpMethod.POST.name().equalsIgnoreCase(httpMethod)) {
                finalGetUrl = pollingContext.getData("Location");
            } else {
                return Mono.error((Throwable)new AzureException("Cannot get final result"));
            }
        }
        if (finalGetUrl == null) {
            String latestResponseBody = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponse(BinaryData.fromString(latestResponseBody), this.serializer, resultType);
        }
        finalGetUrl = this.setServiceVersionQueryParam(finalGetUrl);
        HttpRequest request = new HttpRequest(HttpMethod.GET, finalGetUrl);
        return FluxUtil.withContext(context1 -> this.httpPipeline.send(request, CoreUtils.mergeContexts(context1, this.context))).flatMap(HttpResponse::getBodyAsByteArray).map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, resultType));
    }
}

