/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.nifi.properties.ClientBasedEncodedSensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProtectionException;

public class AzureKeyVaultKeySensitivePropertyProvider
extends ClientBasedEncodedSensitivePropertyProvider<CryptographyClient> {
    protected static final String ENCRYPTION_ALGORITHM_PROPERTY = "azure.keyvault.encryption.algorithm";
    protected static final List<KeyOperation> REQUIRED_OPERATIONS = Arrays.asList(KeyOperation.DECRYPT, KeyOperation.ENCRYPT);
    private static final String IDENTIFIER_KEY = "azure/keyvault/key";
    private EncryptionAlgorithm encryptionAlgorithm;

    AzureKeyVaultKeySensitivePropertyProvider(CryptographyClient cryptographyClient, Properties properties) {
        super((Object)cryptographyClient, properties);
    }

    public String getIdentifierKey() {
        return IDENTIFIER_KEY;
    }

    protected void validate(CryptographyClient cryptographyClient) {
        if (cryptographyClient == null) {
            this.logger.debug("Azure Cryptography Client not configured");
        } else {
            try {
                KeyVaultKey keyVaultKey = cryptographyClient.getKey();
                String id = keyVaultKey.getId();
                KeyProperties keyProperties = keyVaultKey.getProperties();
                if (keyProperties.isEnabled().booleanValue()) {
                    List keyOperations = keyVaultKey.getKeyOperations();
                    if (!keyOperations.containsAll(REQUIRED_OPERATIONS)) {
                        throw new SensitivePropertyProtectionException(String.format("Azure Key Vault Key [%s] Missing Operations %s", id, REQUIRED_OPERATIONS));
                    }
                } else {
                    throw new SensitivePropertyProtectionException(String.format("Azure Key Vault Key [%s] Disabled", id));
                }
                this.logger.info("Azure Key Vault Key [{}] Validated", (Object)id);
            }
            catch (RuntimeException e) {
                throw new SensitivePropertyProtectionException("Azure Key Vault Key Validation Failed", (Throwable)e);
            }
            String algorithm = this.getProperties().getProperty(ENCRYPTION_ALGORITHM_PROPERTY);
            if (algorithm == null || algorithm.isEmpty()) {
                throw new SensitivePropertyProtectionException("Azure Key Vault Key Algorithm not configured");
            }
            this.encryptionAlgorithm = EncryptionAlgorithm.fromString((String)algorithm);
        }
    }

    protected byte[] getEncrypted(byte[] bytes) {
        EncryptResult encryptResult = ((CryptographyClient)this.getClient()).encrypt(this.encryptionAlgorithm, bytes);
        return encryptResult.getCipherText();
    }

    protected byte[] getDecrypted(byte[] bytes) {
        DecryptResult decryptResult = ((CryptographyClient)this.getClient()).decrypt(this.encryptionAlgorithm, bytes);
        return decryptResult.getPlainText();
    }
}

