/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface NodeTypeProvider {
    public boolean isClustered();

    default public boolean isConfiguredForClustering() {
        return false;
    }

    default public boolean isConnected() {
        return false;
    }

    public boolean isPrimary();

    default public Optional<String> getCurrentNode() {
        if (this.isClustered()) {
            throw new IllegalStateException("Clustered environment is not handled!");
        }
        return Optional.empty();
    }

    default public Set<String> getClusterMembers() {
        if (this.isClustered()) {
            throw new IllegalStateException("Clustered environment is not handled!");
        }
        return Collections.emptySet();
    }
}

