/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.transformers;

import de.vandermeer.skb.interfaces.transformers.Transformer;
import org.apache.commons.lang3.Validate;

public interface TransformerArray<FROM, TO>
extends Transformer<FROM, TO> {
    public Transformer<FROM, TO>[] getTransformers();

    @Override
    default public TO transform(FROM from) {
        Validate.notNull(from);
        Validate.notNull(this.getTransformers());
        Validate.noNullElements((Object[])this.getTransformers());
        TO ret = null;
        for (Transformer<FROM, TO> tf : this.getTransformers()) {
            try {
                ret = tf.transform(from);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ret == null) continue;
            return ret;
        }
        throw new IllegalArgumentException("none of the transformers in the array could do a non-null transformation");
    }

    @Override
    default public TO apply(FROM f) {
        return this.transform(f);
    }

    public static <FROM, TO> TransformerArray<FROM, TO> create(final Transformer<FROM, TO>[] transformers) {
        return new TransformerArray<FROM, TO>(){

            @Override
            public Transformer<FROM, TO>[] getTransformers() {
                Validate.notNull((Object)transformers);
                Validate.noNullElements((Object[])transformers);
                return transformers;
            }
        };
    }
}

