/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseImpl;
import org.apache.nutch.parse.ParseText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseResult
implements Iterable<Map.Entry<Text, Parse>> {
    private Map<Text, Parse> parseMap = new HashMap<Text, Parse>();
    private String originalUrl;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ParseResult(String originalUrl) {
        this.originalUrl = originalUrl;
    }

    public static ParseResult createParseResult(String url, Parse parse) {
        ParseResult parseResult = new ParseResult(url);
        parseResult.put(new Text(url), new ParseText(parse.getText()), parse.getData());
        return parseResult;
    }

    public boolean isEmpty() {
        return this.parseMap.isEmpty();
    }

    public int size() {
        return this.parseMap.size();
    }

    public Parse get(String key) {
        return this.get(new Text(key));
    }

    public Parse get(Text key) {
        return this.parseMap.get(key);
    }

    public void put(Text key, ParseText text, ParseData data) {
        this.put(key.toString(), text, data);
    }

    public void put(String key, ParseText text, ParseData data) {
        this.parseMap.put(new Text(key), new ParseImpl(text, data, key.equals(this.originalUrl)));
    }

    @Override
    public Iterator<Map.Entry<Text, Parse>> iterator() {
        return this.parseMap.entrySet().iterator();
    }

    public void filter() {
        Iterator<Map.Entry<Text, Parse>> i = this.iterator();
        while (i.hasNext()) {
            Map.Entry<Text, Parse> entry = i.next();
            if (entry.getValue().getData().getStatus().isSuccess()) continue;
            LOG.warn("{} is not parsed successfully, filtering", (Object)entry.getKey());
            i.remove();
        }
    }

    public boolean isSuccess() {
        for (Map.Entry<Text, Parse> entry : this) {
            if (entry.getValue().getData().getStatus().isSuccess()) continue;
            return false;
        }
        return true;
    }

    public boolean isAnySuccess() {
        for (Map.Entry<Text, Parse> entry : this) {
            if (!entry.getValue().getData().getStatus().isSuccess()) continue;
            return true;
        }
        return false;
    }
}

