/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grep {
    protected boolean invert;
    protected Pattern regex;
    protected List<String> files;
    protected Integer field;
    protected Integer group;

    protected static Grep parseArguments(String[] args) throws Exception {
        Grep g = new Grep();
        for (String arg : args) {
            if (arg.equals("-v") || arg.equals("--invert-match")) {
                g.setInvertMatch(true);
                continue;
            }
            if (arg.matches("-k\\d+")) {
                g.setField(Integer.valueOf(arg.substring(2)));
                continue;
            }
            if (arg.matches("--key=\\d+")) {
                g.setField(Integer.valueOf(arg.substring(6)));
                continue;
            }
            if (arg.matches("-g\\d+")) {
                g.setGroup(Integer.valueOf(arg.substring(2)));
                continue;
            }
            if (arg.matches("--group=\\d+")) {
                g.setGroup(Integer.valueOf(arg.substring(8)));
                continue;
            }
            if (arg.matches("-o") || arg.equals("--only-matching")) {
                g.setGroup(0);
                continue;
            }
            if (g.getRegex() == null) {
                g.setRegex(Pattern.compile(arg));
                continue;
            }
            g.addFile(arg);
        }
        return g;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Grep.printHelp(System.err);
            System.exit(1);
        } else if (args[0].equals("-h") || args[0].equals("-?") || args[0].equals("--help")) {
            Grep.printHelp(System.out);
            System.exit(0);
        }
        Grep g = Grep.parseArguments(args);
        g.doTheGrepThing();
    }

    protected static void printHelp(PrintStream out) {
        out.println("Usage:");
        out.println("  jgrep [-v] [-kPOS] [-gGROUP] [-o] PATTERN [FILE]...");
        out.println();
        out.println("Sort of like grep(1), but using java regular expressions, and with a couple of");
        out.println("unique options.");
        out.println();
        out.println("Options:");
        out.println("  -v, --invert-match    Select non-matching lines");
        out.println("  -k, --key=POS         Match the given whitespace-delimited field, somewhat");
        out.println("                        analogous to sort -k");
        out.println("  -g, --group=GROUP     Print the value of the specified capturing group,");
        out.println("                        instead of the whole matching line");
        out.println("  -o, --only-matching   Print only the part of a matching line that matches,");
        out.println("                        equivalent to --group=0");
        out.println("  -h, --help");
    }

    protected Grep() {
    }

    protected void setField(Integer field) {
        this.field = field;
    }

    protected void setInvertMatch(boolean invert) {
        this.invert = invert;
    }

    protected void setGroup(Integer group) {
        this.group = group;
    }

    protected void setRegex(Pattern regex) {
        this.regex = regex;
    }

    protected void addFile(String path) {
        if (this.files == null) {
            this.files = new LinkedList<String>();
        }
        this.files.add(path);
    }

    protected Pattern getRegex() {
        return this.regex;
    }

    protected void doTheGrepThing() throws Exception {
        if (this.regex == null) {
            throw new Exception("no regex?");
        }
        if (this.files != null) {
            if (this.files.size() == 1) {
                this.grep(new BufferedReader(new FileReader(this.files.get(0))), "");
            } else {
                for (String path : this.files) {
                    this.grep(new BufferedReader(new FileReader(path)), path + ": ");
                }
            }
        } else {
            this.grep(new BufferedReader(new InputStreamReader(System.in)), "");
        }
    }

    protected void grep(BufferedReader reader, String prefix) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            block7: {
                boolean matches;
                Matcher matcher;
                block8: {
                    block6: {
                        if (this.field == null) break block6;
                        int n = this.field - 1;
                        String[] fields = line.split("\\s+", n + 2);
                        if (fields.length < n + 1) break block7;
                        matcher = this.regex.matcher(fields[n]);
                        matches = matcher.find();
                        break block8;
                    }
                    matcher = this.regex.matcher(line);
                    matches = matcher.find();
                }
                if (matches && !this.invert) {
                    if (this.group != null) {
                        System.out.println(prefix + matcher.group(this.group));
                    } else {
                        System.out.println(prefix + line);
                    }
                } else if (!matches && this.invert) {
                    System.out.println(prefix + line);
                }
            }
            line = reader.readLine();
        }
    }
}

