/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.function.BiFunction;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Propagator;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;

class OpenTelemetryPropagator
implements Propagator {
    private final Tracer tracer;
    private final TextMapPropagator httpTextFormat;

    OpenTelemetryPropagator(Tracer tracer, TextMapPropagator httpTextFormat) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.httpTextFormat = (TextMapPropagator)Require.nonNull((String)"HTTP text injector/extractor", (Object)httpTextFormat);
    }

    @Override
    public <C> void inject(TraceContext toInject, C carrier, Propagator.Setter<C> setter) {
        Require.nonNull((String)"Trace context to inject to", (Object)toInject);
        Require.nonNull((String)"Carrier", carrier);
        Require.nonNull((String)"Setter", setter);
        Require.argument((String)"Trace context", (Object)toInject).instanceOf(OpenTelemetryContext.class);
        TextMapSetter propagatorSetter = setter::set;
        this.httpTextFormat.inject(((OpenTelemetryContext)toInject).getContext(), carrier, propagatorSetter);
    }

    @Override
    public <C> OpenTelemetryContext extractContext(TraceContext existing, C carrier, final BiFunction<C, String, String> getter) {
        Require.nonNull((String)"Trace context to extract from", (Object)existing);
        Require.nonNull((String)"Carrier", carrier);
        Require.nonNull((String)"Getter", getter);
        Require.argument((String)"Trace context", (Object)existing).instanceOf(OpenTelemetryContext.class);
        TextMapGetter propagatorGetter = new TextMapGetter<C>(){

            public Iterable<String> keys(C carrier) {
                return null;
            }

            public String get(C carrier, String key) {
                return (String)getter.apply(carrier, key);
            }
        };
        Context extracted = this.httpTextFormat.extract(((OpenTelemetryContext)existing).getContext(), carrier, propagatorGetter);
        String id = Span.fromContext((Context)extracted).getSpanContext().getSpanId();
        if (Span.getInvalid().getSpanContext().getSpanId().equals(id)) {
            return (OpenTelemetryContext)existing;
        }
        return new OpenTelemetryContext(this.tracer, extracted);
    }
}

