/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.asterisk;

import java.util.LinkedList;
import org.asteriskjava.lock.Lockable;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.internal.asterisk.RoomOwner;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class MeetmeRoom
extends Lockable {
    private final int roomNumber;
    private static final Log logger = LogFactory.getLog(MeetmeRoom.class);
    LinkedList<Channel> channels = new LinkedList();
    private int channelCount = 0;
    private boolean active = false;
    private boolean forceClose = false;
    private Long lastUpdated = null;
    private RoomOwner owner = null;

    public MeetmeRoom(int number) {
        this.roomNumber = number;
    }

    public boolean addChannel(Channel channel) {
        try (Locker.LockCloser closer = this.withLock();){
            boolean newChannel = false;
            if (!this.channels.contains(channel)) {
                this.channels.add(channel);
                ++this.channelCount;
                newChannel = true;
            } else {
                logger.error("rejecting " + channel + " already in meetme.");
            }
            boolean bl = newChannel;
            return bl;
        }
    }

    public int getChannelCount() {
        try (Locker.LockCloser closer = this.withLock();){
            int n = this.channelCount;
            return n;
        }
    }

    public Channel[] getChannels() {
        try (Locker.LockCloser closer = this.withLock();){
            Channel[] list = new Channel[this.channels.size()];
            int cnt = 0;
            for (Channel channel : this.channels) {
                list[cnt++] = channel;
            }
            Channel[] channelArray = list;
            return channelArray;
        }
    }

    public boolean getForceClose() {
        return this.forceClose;
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public String getRoomNumber() {
        return "" + this.roomNumber;
    }

    public boolean isActive() {
        return this.active;
    }

    public void removeChannel(Channel channel) {
        try (Locker.LockCloser closer = this.withLock();){
            boolean channelCountInSync = this.channelCount == this.channels.size();
            boolean removed = this.channels.remove(channel);
            if (!removed) {
                logger.warn("An attempt to remove an non-existing channel " + channel + " from Meetme Room " + this.getRoomNumber());
            }
            if (channelCountInSync && removed) {
                --this.channelCount;
            }
            if (!channelCountInSync && removed) {
                --this.channelCount;
            }
            if (this.channels.size() < 2 && this.channels.size() > 0 && !this.channels.get(0).isLocal()) {
                logger.warn("One channel left in the meet me room " + this.channels.get(0) + " room " + this.roomNumber);
            }
        }
    }

    public void setActive() {
        this.active = true;
    }

    public void setForceClose(boolean canClose) {
        this.forceClose = canClose;
    }

    public void setInactive() {
        this.active = false;
        this.channels.clear();
        this.forceClose = false;
        this.lastUpdated = null;
        this.owner = null;
    }

    public void setLastUpdated() {
        this.lastUpdated = System.currentTimeMillis();
    }

    public void resetChannelCount(int resetChannelCount) {
        this.channelCount = resetChannelCount;
    }

    public RoomOwner getOwner() {
        return this.owner;
    }

    public void setOwner(RoomOwner newOwner) {
        this.owner = newOwner;
        this.owner.setRoom(this);
        this.setActive();
    }

    public void removeOwner(RoomOwner toRemove) {
        if (this.owner == toRemove || this.owner == null) {
            this.owner = null;
        } else {
            logger.error("Tring to remove the owner, but it's not the current owner. Owner=" + this.owner + " caller=" + toRemove);
        }
    }
}

