/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.cli;

import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.openmeetings.cli.Db2Patcher;
import org.apache.openmeetings.cli.H2Patcher;
import org.apache.openmeetings.cli.MssqlPatcher;
import org.apache.openmeetings.cli.MysqlPatcher;
import org.apache.openmeetings.cli.OraclePatcher;
import org.apache.openmeetings.cli.PostgresPatcher;
import org.apache.openmeetings.db.util.XmlHelper;
import org.apache.openmeetings.util.ConnectionProperties;
import org.apache.openmeetings.util.OmFileHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ConnectionPropertiesPatcher {
    public static final String DEFAULT_DB_NAME = "openmeetings";
    protected static final String URL_PREFIX = "Url";
    protected static final String DRIVER_PREFIX = "DriverClassName";
    protected static final String USER_PREFIX = "Username";
    protected static final String PASS_PREFIX = "Password";
    protected ConnectionProperties props;

    public static ConnectionPropertiesPatcher getPatcher(ConnectionProperties props) {
        ConnectionPropertiesPatcher patcher = switch (props.getDbType()) {
            case ConnectionProperties.DbType.DB2 -> new Db2Patcher();
            case ConnectionProperties.DbType.MSSQL -> new MssqlPatcher();
            case ConnectionProperties.DbType.MYSQL -> new MysqlPatcher();
            case ConnectionProperties.DbType.ORACLE -> new OraclePatcher();
            case ConnectionProperties.DbType.POSTGRESQL -> new PostgresPatcher();
            default -> new H2Patcher();
        };
        patcher.props = props;
        return patcher;
    }

    public static ConnectionProperties getConnectionProperties(File conf) throws Exception {
        ConnectionProperties props = new ConnectionProperties();
        Document doc = ConnectionPropertiesPatcher.getDocument(conf);
        Attr attr = ConnectionPropertiesPatcher.getConnectionProperties(doc);
        String[] tokens = attr.getValue().split(",");
        ConnectionPropertiesPatcher.loadProperties(tokens, props);
        return props;
    }

    private static Document getDocument(File xml) throws Exception {
        return XmlHelper.createBuilder().parse(xml);
    }

    private static Attr getConnectionProperties(Document doc) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xPath.compile("/persistence/persistence-unit/properties/property[@name='openjpa.ConnectionProperties']");
        Element element = (Element)expr.evaluate(doc, XPathConstants.NODE);
        return element.getAttributeNode("value");
    }

    public static void patch(ConnectionProperties props) throws Exception {
        ConnectionPropertiesPatcher patcher = ConnectionPropertiesPatcher.getPatcher(props);
        Document doc = ConnectionPropertiesPatcher.getDocument(OmFileHelper.getPersistence((ConnectionProperties.DbType)props.getDbType()));
        Attr attr = ConnectionPropertiesPatcher.getConnectionProperties(doc);
        Object[] tokens = attr.getValue().split(",");
        patcher.patchAttribute((String[])tokens);
        attr.setValue(StringUtils.join((Object[])tokens, (String)","));
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer();
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, new StreamResult(OmFileHelper.getPersistence().getCanonicalPath()));
    }

    public static ConnectionProperties patch(ConnectionProperties.DbType dbType, String host, String port, String db, String user, String pass) throws Exception {
        ConnectionProperties props = ConnectionPropertiesPatcher.getConnectionProperties(OmFileHelper.getPersistence((ConnectionProperties.DbType)dbType));
        props.setLogin(user);
        props.setPassword(pass);
        ConnectionPropertiesPatcher patcher = ConnectionPropertiesPatcher.getPatcher(props);
        props.setURL(patcher.getUrl(props.getURL(), host, port, db));
        ConnectionPropertiesPatcher.patch(props);
        return props;
    }

    public static void updateUrl(ConnectionProperties props, String host, String port, String db) {
        ConnectionPropertiesPatcher patcher = ConnectionPropertiesPatcher.getPatcher(props);
        props.setURL(patcher.getUrl(props.getURL(), host, port, db));
    }

    protected void patchAttribute(String[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            ConnectionPropertiesPatcher.patchProp(tokens, i, USER_PREFIX, this.props.getLogin() == null ? "" : this.props.getLogin());
            ConnectionPropertiesPatcher.patchProp(tokens, i, PASS_PREFIX, this.props.getPassword() == null ? "" : this.props.getPassword());
            ConnectionPropertiesPatcher.patchProp(tokens, i, URL_PREFIX, this.props.getURL());
        }
    }

    protected static void patchProp(String[] tokens, int idx, String name, String value) {
        String prop = tokens[idx].trim();
        if (prop.startsWith(name)) {
            tokens[idx] = String.format("%s=%s", name, value);
        }
    }

    private static void loadProperties(String[] tokens, ConnectionProperties connectionProperties) {
        for (int i = 0; i < tokens.length; ++i) {
            String prop = ConnectionPropertiesPatcher.getPropFromPersistence(tokens, i, DRIVER_PREFIX);
            if (prop != null) {
                connectionProperties.setDriver(prop);
            }
            if ((prop = ConnectionPropertiesPatcher.getPropFromPersistence(tokens, i, USER_PREFIX)) != null) {
                connectionProperties.setLogin(prop);
            }
            if ((prop = ConnectionPropertiesPatcher.getPropFromPersistence(tokens, i, PASS_PREFIX)) != null) {
                connectionProperties.setPassword(prop);
            }
            if ((prop = ConnectionPropertiesPatcher.getPropFromPersistence(tokens, i, URL_PREFIX)) == null) continue;
            try {
                String[] parts = prop.split(":");
                connectionProperties.setDbType(ConnectionProperties.DbType.of((String)parts[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            connectionProperties.setURL(prop);
        }
    }

    protected static String getPropFromPersistence(String[] tokens, int idx, String name) {
        String prop = tokens[idx].trim();
        if (prop.startsWith(name)) {
            return prop.substring(prop.indexOf(61) + 1);
        }
        return null;
    }

    protected abstract String getUrl(String var1, String var2, String var3, String var4);
}

