/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.exception;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContextHolder;
import org.apache.qpid.server.query.engine.exception.QueryEngineException;

public class QueryEvaluationException
extends QueryEngineException {
    protected QueryEvaluationException() {
    }

    protected QueryEvaluationException(String message) {
        super(message);
    }

    protected QueryEvaluationException(Throwable throwable) {
        super(throwable);
    }

    protected QueryEvaluationException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public static <R> QueryEvaluationException invalidFunctionParameter(String functionName, R parameter) {
        String parameterType = parameter == null ? "null" : parameter.getClass().getSimpleName();
        String errorMessage = String.format("Parameter of function '%s' invalid (parameter type: %s)", functionName, parameterType);
        return new QueryEvaluationException(errorMessage);
    }

    public static QueryEvaluationException invalidFunctionParameters(String functionName, List<?> invalidArgs) {
        List types = invalidArgs.stream().map(Object::getClass).map(Class::getSimpleName).distinct().collect(Collectors.toList());
        String errorMessage = String.format("Parameters of function '%s' invalid (invalid types: %s)", functionName, types);
        return new QueryEvaluationException(errorMessage);
    }

    public static QueryEvaluationException emptyFunctionParameter(String functionName, int argNumber) {
        String errorMessage = String.format("Function '%s' requires argument %d to be a non-empty string", functionName, argNumber);
        return new QueryEvaluationException(errorMessage);
    }

    public static QueryEvaluationException functionParameterLessThanOne(String functionName, int argNumber) {
        String errorMessage = String.format("Function '%s' requires argument %d to be an integer greater than 0", functionName, argNumber);
        return new QueryEvaluationException(errorMessage);
    }

    public static QueryEvaluationException fieldNotFound(String property) {
        List<String> domains = EvaluationContextHolder.getEvaluationContext().currentExecution().getDomains();
        if (domains.size() == 1) {
            return QueryEvaluationException.of("Domain '%s' does not contain field '%s'", domains.get(0), property);
        }
        return QueryEvaluationException.of("Domains %s do not contain field '%s'", domains, property);
    }

    public static QueryEvaluationException of(String message, Object ... args) {
        return new QueryEvaluationException(String.format(message, args));
    }
}

