/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.rep.impl.RepGroupDB;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import java.io.File;
import java.io.PrintStream;
import java.util.LinkedList;

public class DbDumpGroup {
    private final PrintStream out;
    private File envHome = null;
    private boolean dumpCount = false;

    private DbDumpGroup(PrintStream out) {
        this.out = out;
    }

    public static void main(String[] args) throws Exception {
        DbDumpGroup dumper = new DbDumpGroup(System.out);
        dumper.parseArgs(args);
        try {
            dumper.run();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void run() {
        this.out.println("For internal use only. Consider using the public utility com.sleepycat.je.rep.DbGroupAdmin when displaying group information.");
        this.out.println("Environment: " + this.envHome);
        if (this.dumpCount) {
            this.dumpCount();
        }
        this.dumpGroup();
    }

    private void dumpCount() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        envConfig.setAllowCreate(false);
        Environment env = new Environment(this.envHome, envConfig);
        LinkedList<String> databaseNames = new LinkedList<String>();
        databaseNames.addAll(env.getDatabaseNames());
        for (String dbName : databaseNames) {
            DatabaseConfig dbCfg = new DatabaseConfig();
            dbCfg.setAllowCreate(false);
            dbCfg.setReadOnly(true);
            DbInternal.setUseExistingConfig(dbCfg, true);
            Database db = env.openDatabase(null, dbName, dbCfg);
            this.out.println("Database: " + dbName + ", Count: " + db.count());
            db.close();
        }
        env.close();
    }

    private void dumpGroup() {
        RepGroupImpl group = RepGroupDB.getGroup(this.envHome);
        this.out.println(group);
    }

    public void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-dumpCount")) {
                this.dumpCount = true;
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    private void printUsage(String msg) {
        if (msg != null) {
            this.out.println(msg);
        }
        this.out.println("Usage: " + DbDumpGroup.class.getName());
        this.out.println("       -h <dir>   # environment home directory");
        this.out.println("       -dumpCount # dump all databases' count in\n                    this Environment");
        System.exit(-1);
    }
}

