/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.security.TokenCarryingPrincipal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.KerberosAuthenticationManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoAuthenticator.class);
    public static final String REQUEST_AUTH_HEADER_NAME = "Authorization";
    public static final String RESPONSE_AUTH_HEADER_NAME = "WWW-Authenticate";
    public static final String RESPONSE_AUTH_HEADER_VALUE_NEGOTIATE = "Negotiate";
    public static final String AUTH_TYPE = "SPNEGO";
    static final String NEGOTIATE_PREFIX = "Negotiate ";
    private final KerberosAuthenticationManager _kerberosProvider;

    SpnegoAuthenticator(KerberosAuthenticationManager kerberosProvider) {
        this._kerberosProvider = kerberosProvider;
    }

    public AuthenticationResult authenticate(String authorizationHeader) {
        byte[] decodedNegotiateHeader;
        if (authorizationHeader == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("'Authorization' header is not set");
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        if (!this.hasNegotiatePrefix(authorizationHeader)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("'Authorization' header value does not start with '{}'", (Object)NEGOTIATE_PREFIX);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        String negotiateToken = authorizationHeader.substring(NEGOTIATE_PREFIX.length());
        try {
            decodedNegotiateHeader = Base64.getDecoder().decode(negotiateToken);
        }
        catch (RuntimeException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ticket decoding failed", (Throwable)e);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        if (decodedNegotiateHeader.length == 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Empty ticket");
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        return this.authenticate(decodedNegotiateHeader);
    }

    private boolean hasNegotiatePrefix(String authorizationHeader) {
        if (authorizationHeader.length() > NEGOTIATE_PREFIX.length()) {
            return NEGOTIATE_PREFIX.equalsIgnoreCase(authorizationHeader.substring(0, NEGOTIATE_PREFIX.length()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(byte[] negotiateToken) {
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(this._kerberosProvider.getSpnegoLoginConfigScope());
            loginContext.login();
            Subject subject = loginContext.getSubject();
            AuthenticationResult authenticationResult = this.doAuthenticate(subject, negotiateToken);
            return authenticationResult;
        }
        catch (LoginException e) {
            LOGGER.error("JASS login failed", (Throwable)e);
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
            return authenticationResult;
        }
        finally {
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException loginException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthenticationResult doAuthenticate(Subject subject, byte[] negotiateToken) {
        Object manager;
        GSSContext context = null;
        try {
            GSSContext gssContext;
            int credentialLifetime = String.valueOf(System.getProperty("java.vendor")).toUpperCase().contains("IBM") ? Integer.MAX_VALUE : 0;
            manager = GSSManager.getInstance();
            PrivilegedExceptionAction<GSSCredential> credentialsAction = () -> SpnegoAuthenticator.lambda$doAuthenticate$0((GSSManager)manager, credentialLifetime);
            context = gssContext = ((GSSManager)manager).createContext(Subject.doAs(subject, credentialsAction));
            PrivilegedExceptionAction<byte[]> acceptAction = () -> gssContext.acceptSecContext(negotiateToken, 0, negotiateToken.length);
            final byte[] outToken = Subject.doAs(subject, acceptAction);
            if (outToken == null) {
                LOGGER.debug("Ticket validation failed");
                AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
                return authenticationResult;
            }
            PrivilegedAction<String> authenticationAction = () -> {
                if (gssContext.isEstablished()) {
                    GSSName gssName = null;
                    try {
                        gssName = gssContext.getSrcName();
                    }
                    catch (GSSException e) {
                        LOGGER.error("Unable to get src name from gss context", (Throwable)e);
                    }
                    if (gssName != null) {
                        return this.stripRealmNameIfRequired(gssName.toString());
                    }
                }
                return null;
            };
            final String principalName = Subject.doAs(subject, authenticationAction);
            if (principalName != null) {
                TokenCarryingPrincipal principal = new TokenCarryingPrincipal(){
                    private final Map<String, String> _tokens;
                    {
                        this._tokens = Collections.singletonMap(SpnegoAuthenticator.RESPONSE_AUTH_HEADER_NAME, SpnegoAuthenticator.NEGOTIATE_PREFIX + Base64.getEncoder().encodeToString(outToken));
                    }

                    @Override
                    public Map<String, String> getTokens() {
                        return this._tokens;
                    }

                    @Override
                    public ConfiguredObject<?> getOrigin() {
                        return SpnegoAuthenticator.this._kerberosProvider;
                    }

                    @Override
                    public String getName() {
                        return principalName;
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (this == o) {
                            return true;
                        }
                        if (!(o instanceof TokenCarryingPrincipal)) {
                            return false;
                        }
                        TokenCarryingPrincipal that = (TokenCarryingPrincipal)o;
                        if (!this.getName().equals(that.getName())) {
                            return false;
                        }
                        if (!this.getTokens().equals(that.getTokens())) {
                            return false;
                        }
                        return this.getOrigin() != null ? this.getOrigin().equals(that.getOrigin()) : that.getOrigin() == null;
                    }

                    @Override
                    public int hashCode() {
                        int result = this.getName().hashCode();
                        result = 31 * result + (this.getOrigin() != null ? this.getOrigin().hashCode() : 0);
                        result = 31 * result + this.getTokens().hashCode();
                        return result;
                    }
                };
                AuthenticationResult authenticationResult = new AuthenticationResult(principal);
                return authenticationResult;
            }
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
            return authenticationResult;
        }
        catch (GSSException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ticket validation failed", (Throwable)e);
            }
            manager = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
            return manager;
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof GSSException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Service login failed", (Throwable)e);
                }
            } else {
                LOGGER.error("Service login failed", (Throwable)e);
            }
            AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
            return authenticationResult;
        }
        finally {
            if (context != null) {
                try {
                    context.dispose();
                }
                catch (GSSException gSSException) {}
            }
        }
    }

    private String stripRealmNameIfRequired(String name) {
        int i;
        if (this._kerberosProvider.isStripRealmFromPrincipalName() && name != null && (i = name.indexOf(64)) > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static /* synthetic */ GSSCredential lambda$doAuthenticate$0(GSSManager manager, int credentialLifetime) throws Exception {
        return manager.createCredential(null, credentialLifetime, new Oid("1.3.6.1.5.5.2"), 2);
    }
}

