/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.MessageQueueListener;
import org.apache.rocketmq.client.consumer.store.OffsetStore;
import org.apache.rocketmq.client.consumer.store.ReadOffsetType;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.PopProcessQueue;
import org.apache.rocketmq.client.impl.consumer.PopRequest;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.impl.consumer.PullRequest;
import org.apache.rocketmq.client.impl.consumer.RebalanceImpl;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class RebalancePushImpl
extends RebalanceImpl {
    private static final long UNLOCK_DELAY_TIME_MILLS = Long.parseLong(System.getProperty("rocketmq.client.unlockDelayTimeMills", "20000"));
    private final DefaultMQPushConsumerImpl defaultMQPushConsumerImpl;

    public RebalancePushImpl(DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        this(null, null, null, null, defaultMQPushConsumerImpl);
    }

    public RebalancePushImpl(String consumerGroup, MessageModel messageModel, AllocateMessageQueueStrategy allocateMessageQueueStrategy, MQClientInstance mQClientFactory, DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        super(consumerGroup, messageModel, allocateMessageQueueStrategy, mQClientFactory);
        this.defaultMQPushConsumerImpl = defaultMQPushConsumerImpl;
    }

    @Override
    public void messageQueueChanged(String topic, Set<MessageQueue> mqAll, Set<MessageQueue> mqDivided) {
        SubscriptionData subscriptionData = (SubscriptionData)this.subscriptionInner.get(topic);
        long newVersion = System.currentTimeMillis();
        log.info("{} Rebalance changed, also update version: {}, {}", new Object[]{topic, subscriptionData.getSubVersion(), newVersion});
        subscriptionData.setSubVersion(newVersion);
        int currentQueueCount = this.processQueueTable.size();
        if (currentQueueCount != 0) {
            int pullThresholdSizeForTopic;
            int pullThresholdForTopic = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdForTopic();
            if (pullThresholdForTopic != -1) {
                int newVal = Math.max(1, pullThresholdForTopic / currentQueueCount);
                log.info("The pullThresholdForQueue is changed from {} to {}", (Object)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdForQueue(), (Object)newVal);
                this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().setPullThresholdForQueue(newVal);
            }
            if ((pullThresholdSizeForTopic = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdSizeForTopic()) != -1) {
                int newVal = Math.max(1, pullThresholdSizeForTopic / currentQueueCount);
                log.info("The pullThresholdSizeForQueue is changed from {} to {}", (Object)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdSizeForQueue(), (Object)newVal);
                this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().setPullThresholdSizeForQueue(newVal);
            }
        }
        this.getmQClientFactory().sendHeartbeatToAllBrokerWithLockV2(true);
        MessageQueueListener messageQueueListener = this.defaultMQPushConsumerImpl.getMessageQueueListener();
        if (null != messageQueueListener) {
            messageQueueListener.messageQueueChanged(topic, mqAll, mqDivided);
        }
    }

    @Override
    public boolean removeUnnecessaryMessageQueue(MessageQueue mq, ProcessQueue pq) {
        if (this.defaultMQPushConsumerImpl.isConsumeOrderly() && MessageModel.CLUSTERING.equals((Object)this.defaultMQPushConsumerImpl.messageModel())) {
            this.defaultMQPushConsumerImpl.getOffsetStore().persist(mq);
            return this.tryRemoveOrderMessageQueue(mq, pq);
        }
        this.defaultMQPushConsumerImpl.getOffsetStore().persist(mq);
        this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(mq);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryRemoveOrderMessageQueue(MessageQueue mq, ProcessQueue pq) {
        try {
            boolean forceUnlock;
            boolean bl = forceUnlock = pq.isDropped() && System.currentTimeMillis() > pq.getLastLockTimestamp() + UNLOCK_DELAY_TIME_MILLS;
            if (!forceUnlock && !pq.getConsumeLock().writeLock().tryLock(500L, TimeUnit.MILLISECONDS)) {
                pq.incTryUnlockTimes();
                return false;
            }
            try {
                this.defaultMQPushConsumerImpl.getOffsetStore().persist(mq);
                this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(mq);
                pq.setLocked(false);
                this.unlock(mq, true);
                boolean bl2 = true;
                return bl2;
            }
            finally {
                if (!forceUnlock) {
                    pq.getConsumeLock().writeLock().unlock();
                }
            }
        }
        catch (Exception e) {
            pq.incTryUnlockTimes();
        }
        return false;
    }

    @Override
    public boolean clientRebalance(String topic) {
        return this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().isClientRebalance() || this.defaultMQPushConsumerImpl.isConsumeOrderly() || MessageModel.BROADCASTING.equals((Object)this.messageModel);
    }

    @Override
    public ConsumeType consumeType() {
        return ConsumeType.CONSUME_PASSIVELY;
    }

    @Override
    public void removeDirtyOffset(MessageQueue mq) {
        this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(mq);
    }

    @Override
    @Deprecated
    public long computePullFromWhere(MessageQueue mq) {
        long result = -1L;
        try {
            result = this.computePullFromWhereWithException(mq);
        }
        catch (MQClientException e) {
            log.warn("Compute consume offset exception, mq={}", (Object)mq);
        }
        return result;
    }

    @Override
    public long computePullFromWhereWithException(MessageQueue mq) throws MQClientException {
        long result = -1L;
        ConsumeFromWhere consumeFromWhere = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeFromWhere();
        OffsetStore offsetStore = this.defaultMQPushConsumerImpl.getOffsetStore();
        switch (consumeFromWhere) {
            case CONSUME_FROM_LAST_OFFSET_AND_FROM_MIN_WHEN_BOOT_FIRST: 
            case CONSUME_FROM_MIN_OFFSET: 
            case CONSUME_FROM_MAX_OFFSET: 
            case CONSUME_FROM_LAST_OFFSET: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    if (mq.getTopic().startsWith("%RETRY%")) {
                        result = 0L;
                        break;
                    }
                    try {
                        result = this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
                        break;
                    }
                    catch (MQClientException e) {
                        log.warn("Compute consume offset from last offset exception, mq={}, exception={}", (Object)mq, (Object)e);
                        throw e;
                    }
                }
                throw new MQClientException(22, "Failed to query consume offset from offset store");
            }
            case CONSUME_FROM_FIRST_OFFSET: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    result = 0L;
                    break;
                }
                throw new MQClientException(22, "Failed to query offset from offset store");
            }
            case CONSUME_FROM_TIMESTAMP: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    if (mq.getTopic().startsWith("%RETRY%")) {
                        try {
                            result = this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
                            break;
                        }
                        catch (MQClientException e) {
                            log.warn("Compute consume offset from last offset exception, mq={}, exception={}", (Object)mq, (Object)e);
                            throw e;
                        }
                    }
                    try {
                        long timestamp = UtilAll.parseDate((String)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeTimestamp(), (String)"yyyyMMddHHmmss").getTime();
                        result = this.mQClientFactory.getMQAdminImpl().searchOffset(mq, timestamp);
                        break;
                    }
                    catch (MQClientException e) {
                        log.warn("Compute consume offset from last offset exception, mq={}, exception={}", (Object)mq, (Object)e);
                        throw e;
                    }
                }
                throw new MQClientException(22, "Failed to query offset from offset store");
            }
        }
        if (result < 0L) {
            throw new MQClientException(1, "Found unexpected result " + result);
        }
        return result;
    }

    @Override
    public int getConsumeInitMode() {
        ConsumeFromWhere consumeFromWhere = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeFromWhere();
        if (ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET == consumeFromWhere) {
            return 0;
        }
        return 1;
    }

    @Override
    public void dispatchPullRequest(List<PullRequest> pullRequestList, long delay) {
        for (PullRequest pullRequest : pullRequestList) {
            if (delay <= 0L) {
                this.defaultMQPushConsumerImpl.executePullRequestImmediately(pullRequest);
                continue;
            }
            this.defaultMQPushConsumerImpl.executePullRequestLater(pullRequest, delay);
        }
    }

    @Override
    public void dispatchPopPullRequest(List<PopRequest> pullRequestList, long delay) {
        for (PopRequest pullRequest : pullRequestList) {
            if (delay <= 0L) {
                this.defaultMQPushConsumerImpl.executePopPullRequestImmediately(pullRequest);
                continue;
            }
            this.defaultMQPushConsumerImpl.executePopPullRequestLater(pullRequest, delay);
        }
    }

    @Override
    public ProcessQueue createProcessQueue() {
        return new ProcessQueue();
    }

    @Override
    public PopProcessQueue createPopProcessQueue() {
        return new PopProcessQueue();
    }
}

