/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.exceptions.CircularDependencyException;
import org.apache.royale.compiler.internal.graph.IGraph;
import org.apache.royale.compiler.internal.graph.IGraphEdge;

public final class TopologicalSort {
    private static <V, E extends IGraphEdge<V>> void depthFirstTraverse(IGraph<V, E> graph, Collection<V> vertices, IVisitor<V, E> visitor, Set<V> visitedSet, Set<V> referencedNonTopologicalVertices, Set<V> currentStackVisitedNodes) throws CircularDependencyException {
        Object[] referencedVerticesArr = vertices.toArray();
        Arrays.sort(referencedVerticesArr, visitor);
        Object[] objectArray = referencedVerticesArr;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object referencedVertexObj;
            Object referencedVertex = referencedVertexObj = objectArray[i];
            currentStackVisitedNodes.add(referencedVertex);
            TopologicalSort.depthFirstTraverse(graph, referencedVertex, visitor, visitedSet, referencedNonTopologicalVertices, currentStackVisitedNodes);
            currentStackVisitedNodes.remove(referencedVertex);
        }
    }

    private static <V, E extends IGraphEdge<V>> void depthFirstTraverse(IGraph<V, E> graph, V v, IVisitor<V, E> visitor, Set<V> visitedSet, Set<V> referencedNonTopologicalVertices, Set<V> currentStackVisitedNodes) throws CircularDependencyException {
        if (!visitedSet.add(v)) {
            return;
        }
        Set<E> outgoingEdges = graph.getOutgoingEdges(v);
        ArrayList referencedTopologicalVertices = new ArrayList(outgoingEdges.size());
        for (IGraphEdge e : outgoingEdges) {
            Object referencedVertex = e.getTo();
            if (visitor.isTopologicalEdge(e)) {
                if (currentStackVisitedNodes.contains(referencedVertex)) {
                    ArrayList orderedNodes = new ArrayList(currentStackVisitedNodes.size() + 1);
                    orderedNodes.addAll(currentStackVisitedNodes);
                    orderedNodes.add(referencedVertex);
                    throw new CircularDependencyException(orderedNodes);
                }
                referencedTopologicalVertices.add(referencedVertex);
                continue;
            }
            referencedNonTopologicalVertices.add(referencedVertex);
        }
        TopologicalSort.depthFirstTraverse(graph, referencedTopologicalVertices, visitor, visitedSet, referencedNonTopologicalVertices, currentStackVisitedNodes);
        visitor.visit(v);
        referencedNonTopologicalVertices.remove(v);
    }

    public static <V, E extends IGraphEdge<V>> void sort(IGraph<V, E> graph, Collection<V> rootedVertices, IVisitor<V, E> visitor) throws CircularDependencyException {
        Collection<V> verticesToVisit = rootedVertices;
        int totalNumVertices = graph.getVertices().size();
        HashSet visitedSet = new HashSet(totalNumVertices);
        HashSet<Object> referencedNonTopologicalVertices = new HashSet<V>(totalNumVertices);
        LinkedHashSet currentStackVisitedNodes = new LinkedHashSet();
        do {
            TopologicalSort.depthFirstTraverse(graph, verticesToVisit, visitor, visitedSet, referencedNonTopologicalVertices, currentStackVisitedNodes);
            verticesToVisit = referencedNonTopologicalVertices;
            referencedNonTopologicalVertices = new HashSet();
        } while (verticesToVisit.size() > 0);
    }

    public static <V, E extends IGraphEdge<V>> List<V> sort(IGraph<V, E> graph, final Comparator<V> vertexComparator) throws CircularDependencyException {
        final ArrayList result = new ArrayList(graph.getVertices().size());
        TopologicalSort.sort(graph, graph.getVertices(), new IVisitor<V, E>(){

            @Override
            public void visit(V v) {
                result.add(v);
            }

            @Override
            public boolean isTopologicalEdge(E e) {
                return true;
            }

            @Override
            public int compare(V a, V b) {
                return vertexComparator.compare(a, b);
            }
        });
        return result;
    }

    public static interface IVisitor<V, E extends IGraphEdge<V>>
    extends Comparator<V> {
        public void visit(V var1);

        public boolean isTopologicalEdge(E var1);
    }
}

