/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as.metadata;

import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.definitions.metadata.ResourceBundleMetaTag;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IFileNodeAccumulator;
import org.apache.royale.compiler.tree.metadata.IResourceBundleTagNode;

public class ResourceBundleTagNode
extends MetaTagNode
implements IResourceBundleTagNode {
    private IdentifierNode bundleNameNode;

    public ResourceBundleTagNode() {
        super("ResourceBundle");
    }

    public void setBundleNameNode(IdentifierNode name) {
        this.bundleNameNode = name;
        this.bundleNameNode.setParent(this);
        this.addToMap(SINGLE_VALUE, name.getName());
        IFileNode fileNode = (IFileNode)this.getAncestorOfType(IFileNode.class);
        if (fileNode instanceof IFileNodeAccumulator) {
            ((IFileNodeAccumulator)((Object)fileNode)).addRequiredResourceBundle(this.getBundleName());
        }
    }

    private String getBundleName() {
        return this.bundleNameNode != null ? this.bundleNameNode.getName() : "";
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addChildInOrder(this.bundleNameNode, fillInOffsets);
    }

    @Override
    protected int getInitialChildCount() {
        return 1;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ResourceBundleTagID;
    }

    @Override
    public IMetaTag buildMetaTag(IFileSpecification containingFileSpec, IDefinition definition) {
        String name = this.getTagName();
        ResourceBundleMetaTag metaTag = new ResourceBundleMetaTag(definition, name, this.getAllAttributes(), this.getBundleName());
        metaTag.setLocation(containingFileSpec, this.getAbsoluteStart(), this.getAbsoluteEnd(), this.getLine(), this.getColumn());
        return metaTag;
    }
}

