/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.apache.sis.xml.bind.FilterByVersion;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.distribution.DataFile;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.quality.CoverageResult;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentationType;

@XmlType(name="QE_CoverageResult_Type", propOrder={"spatialRepresentationType", "resultSpatialRepresentation", "resultContentDescription", "resultFormat", "resultFile"})
@XmlRootElement(name="QE_CoverageResult")
public class DefaultCoverageResult
extends AbstractResult
implements CoverageResult {
    private static final long serialVersionUID = 5860811052940576277L;
    private SpatialRepresentationType spatialRepresentationType;
    private SpatialRepresentation resultSpatialRepresentation;
    private Collection<RangeDimension> resultContent;
    @Deprecated(since="1.3")
    private CoverageDescription resultContentDescription;
    private Format resultFormat;
    private DataFile resultFile;

    public DefaultCoverageResult() {
    }

    public DefaultCoverageResult(CoverageResult object) {
        super((Result)object);
        if (object != null) {
            this.spatialRepresentationType = object.getSpatialRepresentationType();
            this.resultSpatialRepresentation = object.getResultSpatialRepresentation();
            this.resultContentDescription = object.getResultContentDescription();
            this.resultFormat = object.getResultFormat();
            this.resultFile = object.getResultFile();
            if (object instanceof DefaultCoverageResult) {
                this.resultContent = DefaultCoverageResult.copyCollection(((DefaultCoverageResult)object).getResultContent(), RangeDimension.class);
            }
        }
    }

    public static DefaultCoverageResult castOrCopy(CoverageResult object) {
        if (object == null || object instanceof DefaultCoverageResult) {
            return (DefaultCoverageResult)object;
        }
        return new DefaultCoverageResult(object);
    }

    @XmlElement(name="spatialRepresentationType", required=true)
    public SpatialRepresentationType getSpatialRepresentationType() {
        return this.spatialRepresentationType;
    }

    public void setSpatialRepresentationType(SpatialRepresentationType newValue) {
        this.checkWritePermission(this.spatialRepresentationType);
        this.spatialRepresentationType = newValue;
    }

    @XmlElement(name="resultSpatialRepresentation", required=true)
    public SpatialRepresentation getResultSpatialRepresentation() {
        return this.resultSpatialRepresentation;
    }

    public void setResultSpatialRepresentation(SpatialRepresentation newValue) {
        this.checkWritePermission(this.resultSpatialRepresentation);
        this.resultSpatialRepresentation = newValue;
    }

    @UML(identifier="resultContent", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public Collection<RangeDimension> getResultContent() {
        this.resultContent = this.nonNullCollection(this.resultContent, RangeDimension.class);
        return this.resultContent;
    }

    public void setResultContent(Collection<RangeDimension> newValues) {
        this.resultContent = this.writeCollection(newValues, this.resultContent, RangeDimension.class);
    }

    @Deprecated(since="1.3")
    @XmlElement(name="resultContentDescription", namespace="http://standards.iso.org/iso/19115/-2/gmi/1.0")
    public CoverageDescription getResultContentDescription() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.resultContentDescription : null;
    }

    @Deprecated(since="1.3")
    public void setResultContentDescription(CoverageDescription newValue) {
        this.checkWritePermission(this.resultContentDescription);
        this.resultContentDescription = newValue;
    }

    @XmlElement(name="resultFormat", required=true)
    public Format getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(Format newValue) {
        this.checkWritePermission(this.resultFormat);
        this.resultFormat = newValue;
    }

    @XmlElement(name="resultFile", required=true)
    public DataFile getResultFile() {
        return this.resultFile;
    }

    public void setResultFile(DataFile newValue) {
        this.checkWritePermission(this.resultFile);
        this.resultFile = newValue;
    }
}

