/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.sis.util.Classes;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;

public class TimeMethods<T>
implements Serializable {
    private static final long serialVersionUID = 1075289362575825939L;
    public final Class<T> type;
    public static final int BEFORE = 1;
    public static final int AFTER = 2;
    public static final int EQUAL = 0;
    public final transient BiPredicate<T, T> isBefore;
    public final transient BiPredicate<T, T> isAfter;
    public final transient BiPredicate<T, T> isEqual;
    public final transient Supplier<T> now;
    public final transient BiFunction<T, ZoneId, Temporal> withZone;
    private final boolean hasZone;
    private static final TimeMethods<?>[] INTERFACES = new TimeMethods[]{new TimeMethods<ChronoZonedDateTime>(ChronoZonedDateTime.class, ChronoZonedDateTime::isBefore, ChronoZonedDateTime::isAfter, ChronoZonedDateTime::isEqual, ZonedDateTime::now, ChronoZonedDateTime::withZoneSameInstant, true), new TimeMethods<ChronoLocalDateTime>(ChronoLocalDateTime.class, ChronoLocalDateTime::isBefore, ChronoLocalDateTime::isAfter, ChronoLocalDateTime::isEqual, LocalDateTime::now, ChronoLocalDateTime::atZone, false), new TimeMethods<ChronoLocalDate>(ChronoLocalDate.class, ChronoLocalDate::isBefore, ChronoLocalDate::isAfter, ChronoLocalDate::isEqual, LocalDate::now, null, false), new TimeMethods<Date>(Date.class, Date::before, Date::after, Date::equals, Date::new, TimeMethods::atZone, true)};
    private static final Map<Class<?>, TimeMethods<?>> FINAL_TYPES = Map.ofEntries(TimeMethods.entry(new TimeMethods<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::isBefore, OffsetDateTime::isAfter, OffsetDateTime::isEqual, OffsetDateTime::now, TimeMethods::withZoneSameInstant, true)), TimeMethods.entry(new TimeMethods<ZonedDateTime>(ZonedDateTime.class, ChronoZonedDateTime::isBefore, ChronoZonedDateTime::isAfter, ChronoZonedDateTime::isEqual, ZonedDateTime::now, ZonedDateTime::withZoneSameInstant, true)), TimeMethods.entry(new TimeMethods<LocalDateTime>(LocalDateTime.class, LocalDateTime::isBefore, LocalDateTime::isAfter, LocalDateTime::isEqual, LocalDateTime::now, LocalDateTime::atZone, false)), TimeMethods.entry(new TimeMethods<LocalDate>(LocalDate.class, LocalDate::isBefore, LocalDate::isAfter, LocalDate::isEqual, LocalDate::now, null, false)), TimeMethods.entry(new TimeMethods<OffsetTime>(OffsetTime.class, OffsetTime::isBefore, OffsetTime::isAfter, OffsetTime::isEqual, OffsetTime::now, TimeMethods::withOffsetSameInstant, true)), TimeMethods.entry(new TimeMethods<LocalTime>(LocalTime.class, LocalTime::isBefore, LocalTime::isAfter, LocalTime::equals, LocalTime::now, TimeMethods::atOffset, false)), TimeMethods.entry(new TimeMethods<Year>(Year.class, Year::isBefore, Year::isAfter, Year::equals, Year::now, null, false)), TimeMethods.entry(new TimeMethods<YearMonth>(YearMonth.class, YearMonth::isBefore, YearMonth::isAfter, YearMonth::equals, YearMonth::now, null, false)), TimeMethods.entry(new TimeMethods<MonthDay>(MonthDay.class, MonthDay::isBefore, MonthDay::isAfter, MonthDay::equals, MonthDay::now, null, false)), TimeMethods.entry(new TimeMethods<Instant>(Instant.class, Instant::isBefore, Instant::isAfter, Instant::equals, Instant::now, Instant::atZone, true)), TimeMethods.entry(TimeMethods.fallback(Temporal.class)), TimeMethods.entry(TimeMethods.fallback(Object.class)));

    private TimeMethods(Class<T> type, BiPredicate<T, T> isBefore, BiPredicate<T, T> isAfter, BiPredicate<T, T> isEqual, Supplier<T> now, BiFunction<T, ZoneId, Temporal> withZone, boolean hasZone) {
        this.type = type;
        this.isBefore = isBefore;
        this.isAfter = isAfter;
        this.isEqual = isEqual;
        this.now = now;
        this.withZone = withZone;
        this.hasZone = hasZone;
    }

    public boolean isDynamic() {
        return false;
    }

    boolean delegate(int test, T self, T other) {
        BiPredicate<T, T> p;
        switch (test) {
            case 1: {
                p = this.isBefore;
                break;
            }
            case 2: {
                p = this.isAfter;
                break;
            }
            case 0: {
                p = this.isEqual;
                break;
            }
            default: {
                throw new AssertionError(test);
            }
        }
        return p.test(self, other);
    }

    public final boolean compare(int test, T self, TemporalAccessor other) {
        if (this.type.isInstance(other)) {
            return this.delegate(test, self, other);
        }
        return TimeMethods.compareAsInstants(test, TimeMethods.accessor(self), other);
    }

    public static boolean compareAny(int test, Temporal self, Temporal other) {
        return self != null && other != null && TimeMethods.compare(test, Classes.findCommonClass(self.getClass(), other.getClass()), self, other);
    }

    public static <T> boolean compare(int test, Class<T> type, T self, T other) {
        TimeMethods<T> tc = TimeMethods.findSpecialized(type);
        if (tc != null && !tc.isDynamic()) {
            if (tc.type.isInstance(other)) {
                BiPredicate<T, T> p;
                assert (tc.type.isAssignableFrom(type)) : tc;
                switch (test) {
                    case 1: {
                        p = tc.isBefore;
                        break;
                    }
                    case 2: {
                        p = tc.isAfter;
                        break;
                    }
                    case 0: {
                        p = tc.isEqual;
                        break;
                    }
                    default: {
                        throw new AssertionError(test);
                    }
                }
                return p.test(self, other);
            }
        } else if (self instanceof Comparable && self.getClass().isInstance(other)) {
            int c = ((Comparable)self).compareTo(other);
            switch (test) {
                case 1: {
                    return c < 0;
                }
                case 2: {
                    return c > 0;
                }
                case 0: {
                    return c == 0;
                }
            }
            throw new AssertionError(test);
        }
        return TimeMethods.compareAsInstants(test, TimeMethods.accessor(self), TimeMethods.accessor(other));
    }

    private static TemporalAccessor accessor(Object value) {
        if (value instanceof TemporalAccessor) {
            return (TemporalAccessor)value;
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant();
        }
        throw new DateTimeException(Errors.format((short)205, value.getClass(), TemporalAccessor.class));
    }

    private static boolean compareAsInstants(int test, TemporalAccessor self, TemporalAccessor other) {
        long t2;
        long t1 = self.getLong(ChronoField.INSTANT_SECONDS);
        if (t1 == (t2 = other.getLong(ChronoField.INSTANT_SECONDS)) && (t1 = self.getLong(ChronoField.NANO_OF_SECOND)) == (t2 = other.getLong(ChronoField.NANO_OF_SECOND))) {
            return test == 0;
        }
        return test == (t1 < t2 ? 1 : 2);
    }

    private static <T> TimeMethods<? super T> findSpecialized(Class<T> type) {
        TimeMethods<?> tc = FINAL_TYPES.get(type);
        if (tc != null) {
            assert (tc.type == type) : tc;
            return tc;
        }
        for (TimeMethods<?> tc2 : INTERFACES) {
            if (!tc2.type.isAssignableFrom(type)) continue;
            return tc2;
        }
        return null;
    }

    public static <T> TimeMethods<? super T> find(Class<T> type) {
        TimeMethods<T> tc = TimeMethods.findSpecialized(type);
        if (tc != null) {
            return tc;
        }
        if (Modifier.isFinal(type.getModifiers())) {
            if (Comparable.class.isAssignableFrom(type)) {
                return new TimeMethods<Object>(type, (self, other) -> ((Comparable)self).compareTo(other) < 0, (self, other) -> ((Comparable)self).compareTo(other) > 0, (self, other) -> ((Comparable)self).compareTo(other) == 0, null, null, false);
            }
            throw new DateTimeException(Errors.format((short)205, type, type));
        }
        return TimeMethods.fallback(type);
    }

    private static <T> TimeMethods<? super T> fallback(Class<T> type) {
        return new TimeMethods<T>((Class)type, (self, other) -> TimeMethods.compare(1, type, self, other), (self, other) -> TimeMethods.compare(2, type, self, other), (self, other) -> TimeMethods.compare(0, type, self, other), null, null, false){

            @Override
            public boolean isDynamic() {
                return true;
            }

            @Override
            boolean delegate(int test, T self, T other) {
                return 1.compare(test, this.type, self, other);
            }
        };
    }

    private Object readResolve() throws ObjectStreamException {
        return TimeMethods.find(this.type);
    }

    public final Temporal now() {
        if (this.now != null) {
            T time = this.now.get();
            if (time instanceof Temporal) {
                return (Temporal)time;
            }
            if (time instanceof Date) {
                return ((Date)time).toInstant();
            }
            if (time instanceof MonthDay) {
                return LocalDate.now();
            }
        }
        return ZonedDateTime.now();
    }

    public static <T> Optional<Temporal> withZone(T time, ZoneId timezone, boolean allowAdd) {
        if (time != null) {
            TimeMethods<T> methods = TimeMethods.find(Classes.getClass(time));
            if (methods.hasZone | allowAdd && methods.withZone != null) {
                return Optional.ofNullable(methods.withZone.apply(time, timezone));
            }
        }
        return Optional.empty();
    }

    private static Map.Entry<Class<?>, TimeMethods<?>> entry(TimeMethods<?> op) {
        return Map.entry(op.type, op);
    }

    private static Temporal atZone(Date date, ZoneId timezone) {
        Instant time = date.toInstant();
        if (timezone instanceof ZoneOffset) {
            return time.atOffset((ZoneOffset)timezone);
        }
        return time.atZone(timezone);
    }

    private static Temporal withZoneSameInstant(OffsetDateTime time, ZoneId timezone) {
        if (timezone instanceof ZoneOffset) {
            return time.withOffsetSameInstant((ZoneOffset)timezone);
        }
        return time.atZoneSameInstant(timezone);
    }

    private static Temporal withOffsetSameInstant(OffsetTime time, ZoneId timezone) {
        if (timezone instanceof ZoneOffset) {
            return time.withOffsetSameInstant((ZoneOffset)timezone);
        }
        return null;
    }

    private static Temporal atOffset(LocalTime time, ZoneId timezone) {
        if (timezone instanceof ZoneOffset) {
            return time.atOffset((ZoneOffset)timezone);
        }
        return null;
    }

    public String toString() {
        return Strings.toString(TimeMethods.class, (Object[])new Object[]{"type", this.type.getSimpleName()});
    }
}

