/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap.mapping;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.AbstractJDBCConf;
import org.apache.syncope.common.lib.AbstractLDAPConf;
import org.apache.syncope.common.lib.attr.AttrRepoConf;
import org.apache.syncope.common.lib.attr.AzureActiveDirectoryAttrRepoConf;
import org.apache.syncope.common.lib.attr.JDBCAttrRepoConf;
import org.apache.syncope.common.lib.attr.LDAPAttrRepoConf;
import org.apache.syncope.common.lib.attr.OktaAttrRepoConf;
import org.apache.syncope.common.lib.attr.StubAttrRepoConf;
import org.apache.syncope.common.lib.attr.SyncopeAttrRepoConf;
import org.apache.syncope.common.lib.to.AttrRepoTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.bootstrap.mapping.PropertySourceMapper;
import org.apereo.cas.configuration.CasCoreConfigurationUtils;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.configuration.model.core.authentication.StubPrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.azuread.AzureActiveDirectoryAttributesProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcPrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapSearchProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapPrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.okta.OktaPrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.syncope.SyncopePrincipalAttributesProperties;

public class AttrRepoPropertySourceMapper
extends PropertySourceMapper
implements AttrRepoConf.Mapper {
    protected final WARestClient waRestClient;

    public AttrRepoPropertySourceMapper(WARestClient waRestClient) {
        this.waRestClient = waRestClient;
    }

    public Map<String, Object> map(AttrRepoTO attrRepoTO, StubAttrRepoConf conf) {
        StubPrincipalAttributesProperties props = new StubPrincipalAttributesProperties();
        props.setId(attrRepoTO.getKey());
        props.setState(AttributeRepositoryStates.valueOf((String)attrRepoTO.getState().name()));
        props.setOrder(attrRepoTO.getOrder());
        props.setAttributes(conf.getAttributes());
        return AttrRepoPropertySourceMapper.prefix("cas.authn.attribute-repository.stub.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AttrRepoTO attrRepoTO, LDAPAttrRepoConf conf) {
        LdapPrincipalAttributesProperties props = new LdapPrincipalAttributesProperties();
        props.setId(attrRepoTO.getKey());
        props.setState(AttributeRepositoryStates.valueOf((String)attrRepoTO.getState().name()));
        props.setOrder(attrRepoTO.getOrder());
        props.setUseAllQueryAttributes(conf.isUseAllQueryAttributes());
        props.setQueryAttributes(conf.getQueryAttributes());
        props.setAttributes(attrRepoTO.getItems().stream().collect(Collectors.toMap(Item::getIntAttrName, Item::getExtAttrName)));
        this.fill((AbstractLdapSearchProperties)props, (AbstractLDAPConf)conf);
        return AttrRepoPropertySourceMapper.prefix("cas.authn.attribute-repository.ldap[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AttrRepoTO attrRepoTO, JDBCAttrRepoConf conf) {
        JdbcPrincipalAttributesProperties props = new JdbcPrincipalAttributesProperties();
        props.setId(attrRepoTO.getKey());
        props.setState(AttributeRepositoryStates.valueOf((String)attrRepoTO.getState().name()));
        props.setOrder(attrRepoTO.getOrder());
        props.setSql(conf.getSql());
        props.setSingleRow(conf.isSingleRow());
        props.setRequireAllAttributes(conf.isRequireAllAttributes());
        props.setCaseCanonicalization(conf.getCaseCanonicalization().name());
        props.setQueryType(conf.getQueryType().name());
        props.setColumnMappings(conf.getColumnMappings());
        props.setUsername(conf.getUsername());
        props.setCaseInsensitiveQueryAttributes(conf.getCaseInsensitiveQueryAttributes());
        props.setQueryAttributes(conf.getQueryAttributes());
        props.setAttributes(attrRepoTO.getItems().stream().collect(Collectors.toMap(Item::getIntAttrName, Item::getExtAttrName)));
        this.fill((AbstractJpaProperties)props, (AbstractJDBCConf)conf);
        return AttrRepoPropertySourceMapper.prefix("cas.authn.attribute-repository.jdbc[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AttrRepoTO attrRepoTO, SyncopeAttrRepoConf conf) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.warn("Application context is not ready to bootstrap WA configuration");
            return Map.of();
        }
        SyncopePrincipalAttributesProperties props = new SyncopePrincipalAttributesProperties();
        props.setId(attrRepoTO.getKey());
        props.setState(AttributeRepositoryStates.valueOf((String)attrRepoTO.getState().name()));
        props.setOrder(attrRepoTO.getOrder());
        props.setDomain(conf.getDomain());
        props.setUrl(StringUtils.substringBefore((String)syncopeClient.getAddress(), (String)"/rest"));
        props.setSearchFilter(conf.getSearchFilter());
        props.setBasicAuthUsername(conf.getBasicAuthUsername());
        props.setBasicAuthPassword(conf.getBasicAuthPassword());
        props.setHeaders(props.getHeaders());
        props.setAttributeMappings(attrRepoTO.getItems().stream().collect(Collectors.toMap(Item::getIntAttrName, Item::getExtAttrName)));
        return AttrRepoPropertySourceMapper.prefix("cas.authn.attribute-repository.syncope.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AttrRepoTO attrRepoTO, AzureActiveDirectoryAttrRepoConf conf) {
        AzureActiveDirectoryAttributesProperties props = new AzureActiveDirectoryAttributesProperties();
        props.setId(attrRepoTO.getKey());
        props.setOrder(attrRepoTO.getOrder());
        props.setClientId(conf.getClientId());
        props.setClientSecret(conf.getClientSecret());
        props.setLoginBaseUrl(conf.getLoginUrl());
        props.setResource(conf.getResource());
        props.setTenant(conf.getTenant());
        props.setScope(conf.getScope());
        props.setCaseInsensitive(conf.isCaseInsensitive());
        props.setAttributes(attrRepoTO.getItems().stream().map(Item::getExtAttrName).collect(Collectors.joining(",")));
        return AttrRepoPropertySourceMapper.prefix("cas.authn.attribute-repository.azure-active-directory[].", CasCoreConfigurationUtils.asMap((Serializable)props));
    }

    public Map<String, Object> map(AttrRepoTO attrRepoTO, OktaAttrRepoConf conf) {
        OktaPrincipalAttributesProperties props = new OktaPrincipalAttributesProperties();
        props.setId(attrRepoTO.getKey());
        props.setOrder(attrRepoTO.getOrder());
        props.setOrganizationUrl(conf.getOrganizationUrl());
        props.setUsernameAttribute(conf.getUsernameAttribute());
        props.setScopes(conf.getScopes());
        props.setApiToken(conf.getApiToken());
        return AttrRepoPropertySourceMapper.prefix("cas.authn.attribute-repository.okta.", CasCoreConfigurationUtils.asMap((Serializable)props));
    }
}

