/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Assert;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

final class EnumConverter {
    private final Map<Class<Enum>, Map<String, Enum>> cachedEnums = new ConcurrentHashMap<Class<Enum>, Map<String, Enum>>();

    EnumConverter() {
    }

    <E extends Enum<E>> E fromValue(Class<E> enumType, String value) {
        Assert.notNull((Object)value, (String)"[Assertion failed] - 'value' is required; it must not be null");
        Map<String, E> reverseMap = this.getReverseLookupMap(enumType);
        Enum result = (Enum)reverseMap.get(value);
        if (result == null) {
            result = Enum.valueOf(enumType, value);
        }
        return (E)result;
    }

    private <E extends Enum> Map<String, E> getReverseLookupMap(Class<E> type) {
        Map<String, Enum> result = this.cachedEnums.get(type);
        if (result == null) {
            result = Arrays.stream((Enum[])type.getEnumConstants()).collect(Collectors.toMap(Enum::toString, e -> e));
            this.cachedEnums.put(type, result);
        }
        return result;
    }
}

