/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.network.zone;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.network.zone.NetworkZone;
import com.okta.sdk.resource.network.zone.NetworkZoneAddress;
import com.okta.sdk.resource.network.zone.NetworkZoneLocation;
import com.okta.sdk.resource.network.zone.NetworkZoneStatus;
import com.okta.sdk.resource.network.zone.NetworkZoneType;
import com.okta.sdk.resource.network.zone.NetworkZoneUsage;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultNetworkZone
extends AbstractInstanceResource<NetworkZone>
implements NetworkZone {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final ListProperty asnsProperty = new ListProperty("asns");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceListProperty<NetworkZoneAddress> gatewaysProperty = new ResourceListProperty<NetworkZoneAddress>("gateways", NetworkZoneAddress.class);
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final ResourceListProperty<NetworkZoneLocation> locationsProperty = new ResourceListProperty<NetworkZoneLocation>("locations", NetworkZoneLocation.class);
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final ResourceListProperty<NetworkZoneAddress> proxiesProperty = new ResourceListProperty<NetworkZoneAddress>("proxies", NetworkZoneAddress.class);
    private static final StringProperty proxyTypeProperty = new StringProperty("proxyType");
    private static final EnumProperty<NetworkZoneStatus> statusProperty = new EnumProperty<NetworkZoneStatus>("status", NetworkZoneStatus.class);
    private static final BooleanProperty systemProperty = new BooleanProperty("system");
    private static final EnumProperty<NetworkZoneType> typeProperty = new EnumProperty<NetworkZoneType>("type", NetworkZoneType.class);
    private static final EnumProperty<NetworkZoneUsage> usageProperty = new EnumProperty<NetworkZoneUsage>("usage", NetworkZoneUsage.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultNetworkZone.createPropertyDescriptorMap(linksProperty, asnsProperty, createdProperty, gatewaysProperty, idProperty, lastUpdatedProperty, locationsProperty, nameProperty, proxiesProperty, proxyTypeProperty, statusProperty, systemProperty, typeProperty, usageProperty);

    public DefaultNetworkZone(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultNetworkZone(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return NetworkZone.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public List<String> getAsns() {
        return this.getListProperty(asnsProperty);
    }

    public NetworkZone setAsns(List<String> asns) {
        this.setProperty(asnsProperty, asns);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public List<NetworkZoneAddress> getGateways() {
        return this.getResourceListProperty(gatewaysProperty);
    }

    public NetworkZone setGateways(List<NetworkZoneAddress> gateways) {
        this.setProperty(gatewaysProperty, gateways);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public List<NetworkZoneLocation> getLocations() {
        return this.getResourceListProperty(locationsProperty);
    }

    public NetworkZone setLocations(List<NetworkZoneLocation> locations) {
        this.setProperty(locationsProperty, locations);
        return this;
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public NetworkZone setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public List<NetworkZoneAddress> getProxies() {
        return this.getResourceListProperty(proxiesProperty);
    }

    public NetworkZone setProxies(List<NetworkZoneAddress> proxies) {
        this.setProperty(proxiesProperty, proxies);
        return this;
    }

    public String getProxyType() {
        return this.getString(proxyTypeProperty);
    }

    public NetworkZone setProxyType(String proxyType) {
        this.setProperty(proxyTypeProperty, (Object)proxyType);
        return this;
    }

    public NetworkZoneStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public NetworkZone setStatus(NetworkZoneStatus status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public Boolean getSystem() {
        return this.getBoolean(systemProperty);
    }

    public NetworkZone setSystem(Boolean system) {
        this.setProperty(systemProperty, (Object)system);
        return this;
    }

    public NetworkZoneType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public NetworkZone setType(NetworkZoneType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public NetworkZoneUsage getUsage() {
        return this.getEnumProperty(usageProperty);
    }

    public NetworkZone setUsage(NetworkZoneUsage usage) {
        this.setProperty(usageProperty, (Object)usage);
        return this;
    }

    @Override
    public void delete() {
        String zoneId = this.getId();
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/zones/" + zoneId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZone deactivate() {
        String zoneId = this.getId();
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/zones/" + zoneId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, NetworkZone.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public NetworkZone update() {
        String zoneId = this.getId();
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/zones/" + zoneId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public NetworkZone activate() {
        String zoneId = this.getId();
        Assert.hasText((String)zoneId, (String)"'zoneId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/zones/" + zoneId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, NetworkZone.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

