/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv.bean;

import java.util.Locale;
import java.util.ResourceBundle;
import liquibase.repackaged.com.opencsv.bean.AbstractCsvConverter;
import liquibase.repackaged.com.opencsv.exceptions.CsvDataTypeMismatchException;
import liquibase.repackaged.org.apache.commons.lang3.StringUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;

public class ConverterPrimitiveTypes
extends AbstractCsvConverter {
    protected final ConvertUtilsBean readConverter;
    protected final LocaleConvertUtilsBean readLocaleConverter;
    protected final ConvertUtilsBean writeConverter;
    protected final LocaleConvertUtilsBean writeLocaleConverter;

    public ConverterPrimitiveTypes(Class<?> type, String locale, String writeLocale, Locale errorLocale) {
        super(type, locale, writeLocale, errorLocale);
        if (this.locale == null) {
            this.readConverter = new ConvertUtilsBean();
            this.readConverter.register(true, false, 0);
            this.readLocaleConverter = null;
        } else {
            this.readLocaleConverter = new LocaleConvertUtilsBean();
            this.readLocaleConverter.setDefaultLocale(this.locale);
            this.readConverter = null;
        }
        if (this.writeLocale == null) {
            this.writeConverter = new ConvertUtilsBean();
            this.writeConverter.register(true, false, 0);
            this.writeLocaleConverter = null;
        } else {
            this.writeLocaleConverter = new LocaleConvertUtilsBean();
            this.writeLocaleConverter.setDefaultLocale(this.writeLocale);
            this.writeConverter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convertToRead(String value) throws CsvDataTypeMismatchException {
        Object o2;
        block10: {
            o2 = null;
            if (StringUtils.isNotBlank(value) || value != null && this.type.equals(String.class)) {
                try {
                    if (this.readConverter != null) {
                        ConvertUtilsBean convertUtilsBean = this.readConverter;
                        synchronized (convertUtilsBean) {
                            o2 = this.readConverter.convert(value, this.type);
                            break block10;
                        }
                    }
                    LocaleConvertUtilsBean localeConvertUtilsBean = this.readLocaleConverter;
                    synchronized (localeConvertUtilsBean) {
                        o2 = this.readLocaleConverter.convert(value, this.type);
                    }
                }
                catch (ConversionException e2) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, this.type, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("conversion.impossible"), value, this.type.getCanonicalName()));
                    csve.initCause(e2);
                    throw csve;
                }
            }
        }
        return o2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String result;
        block10: {
            result = null;
            if (value != null) {
                try {
                    if (this.writeConverter != null) {
                        ConvertUtilsBean convertUtilsBean = this.writeConverter;
                        synchronized (convertUtilsBean) {
                            result = this.writeConverter.convert(value);
                            break block10;
                        }
                    }
                    LocaleConvertUtilsBean localeConvertUtilsBean = this.writeLocaleConverter;
                    synchronized (localeConvertUtilsBean) {
                        result = this.writeLocaleConverter.convert(value);
                    }
                }
                catch (ConversionException e2) {
                    CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("field.not.primitive"));
                    csve.initCause(e2);
                    throw csve;
                }
            }
        }
        return result;
    }
}

