/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileInputConfig;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.CSVConfPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.common.rest.api.beans.AbstractCSVSpec;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.lang.Bytes;

public class CSVPullWizardBuilder
extends BaseAjaxWizardBuilder<CSVPullSpec> {
    private static final long serialVersionUID = -4049787433975145383L;
    protected final Model<byte[]> csv = new Model();
    protected final ReconciliationRestClient reconciliationRestClient;
    protected final ImplementationRestClient implementationRestClient;
    protected final Bytes maxUploadSize;

    public CSVPullWizardBuilder(CSVPullSpec defaultItem, ReconciliationRestClient reconciliationRestClient, ImplementationRestClient implementationRestClient, PageReference pageRef) {
        super((Serializable)defaultItem, pageRef);
        this.reconciliationRestClient = reconciliationRestClient;
        this.implementationRestClient = implementationRestClient;
        this.maxUploadSize = Bytes.megabytes((long)SyncopeWebApplication.get().getMaxUploadFileSizeMB());
    }

    public CSVPullWizardBuilder setEventSink(IEventSink eventSink) {
        super.setEventSink(eventSink);
        return this;
    }

    protected ArrayList<ProvisioningReport> onApplyInternal(CSVPullSpec modelObject) {
        return this.reconciliationRestClient.pull(modelObject, new ByteArrayInputStream((byte[])this.csv.getObject()));
    }

    protected WizardModel buildModelSteps(CSVPullSpec modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new Columns(modelObject));
        wizardModel.add((IWizardStep)new PullTask(modelObject));
        return wizardModel;
    }

    public class PullTask
    extends WizardStep {
        private static final long serialVersionUID = -8954789648303078732L;
        private final IModel<List<String>> pullActions = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 4659376149825914247L;

            protected List<String> load() {
                return CSVPullWizardBuilder.this.implementationRestClient.list("PULL_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
        private final IModel<List<String>> pullCorrelationRules = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 4659376149825914247L;

            protected List<String> load() {
                return CSVPullWizardBuilder.this.implementationRestClient.list("PULL_CORRELATION_RULE").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };

        public PullTask(CSVPullSpec spec) {
            AjaxCheckBoxPanel remediation = new AjaxCheckBoxPanel("remediation", "remediation", (IModel)new PropertyModel((Object)spec, "remediation"), false);
            this.add(new Component[]{remediation});
            AjaxDropDownChoicePanel matchingRule = new AjaxDropDownChoicePanel("matchingRule", "matchingRule", (IModel)new PropertyModel((Object)spec, "matchingRule"), false);
            matchingRule.setChoices(List.of(MatchingRule.values()));
            this.add(new Component[]{matchingRule});
            AjaxDropDownChoicePanel unmatchingRule = new AjaxDropDownChoicePanel("unmatchingRule", "unmatchingRule", (IModel)new PropertyModel((Object)spec, "unmatchingRule"), false);
            unmatchingRule.setChoices(List.of(UnmatchingRule.values()));
            this.add(new Component[]{unmatchingRule});
            AjaxPalettePanel provisioningActions = new AjaxPalettePanel.Builder().build("provisioningActions", (IModel)new PropertyModel((Object)spec, "provisioningActions"), (IModel)new ListModel((List)this.pullActions.getObject()));
            this.add(new Component[]{provisioningActions});
            AjaxDropDownChoicePanel conflictResolutionAction = new AjaxDropDownChoicePanel("conflictResolutionAction", "conflictResolutionAction", (IModel)new PropertyModel((Object)spec, "conflictResolutionAction"), false);
            conflictResolutionAction.setChoices(List.of(ConflictResolutionAction.values()));
            conflictResolutionAction.setRequired(true);
            this.add(new Component[]{conflictResolutionAction});
            AjaxDropDownChoicePanel pullCorrelationRule = new AjaxDropDownChoicePanel("pullCorrelationRule", "pullCorrelationRule", (IModel)new PropertyModel((Object)spec, "pullCorrelationRule"), false);
            pullCorrelationRule.setChoices(this.pullCorrelationRules);
            this.add(new Component[]{pullCorrelationRule});
        }
    }

    public class Columns
    extends WizardStep
    implements WizardModel.ICondition {
        private static final long serialVersionUID = -4136764210454067728L;
        private final CSVPullSpec spec;
        private final ListModel<String> columnsModel = new ListModel();

        public Columns(final CSVPullSpec spec) {
            this.spec = spec;
            final RadioGroup keyColumn = new RadioGroup("keyColumn", (IModel)new PropertyModel((Object)spec, "keyColumn"));
            keyColumn.setOutputMarkupId(true);
            keyColumn.setOutputMarkupPlaceholderTag(true);
            keyColumn.setRenderBodyOnly(false);
            keyColumn.setRequired(true);
            this.add(new Component[]{keyColumn});
            keyColumn.add(new Component[]{new ListView<String>("columns", this.columnsModel){
                private static final long serialVersionUID = -9112553137618363167L;

                protected void populateItem(final ListItem<String> item) {
                    item.add(new Component[]{new Label("column", (Serializable)item.getModelObject())});
                    item.add(new Component[]{new Radio("key", (IModel)new Model((Serializable)((Object)((String)item.getModelObject()))), keyColumn)});
                    item.add(new Component[]{new AjaxCheckBox("ignore", (IModel)new Model()){
                        private static final long serialVersionUID = -6139318907146065915L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            if (spec.getIgnoreColumns().contains(item.getModelObject())) {
                                spec.getIgnoreColumns().remove(item.getModelObject());
                            } else {
                                spec.getIgnoreColumns().add((String)item.getModelObject());
                            }
                        }
                    }});
                }
            }.setReuseItems(true)});
        }

        public boolean evaluate() {
            if (CSVPullWizardBuilder.this.csv.getObject() != null) {
                String header = StringUtils.substringBefore((String)new String((byte[])CSVPullWizardBuilder.this.csv.getObject()), (String)this.spec.getLineSeparator());
                this.columnsModel.setObject(Stream.of(StringUtils.split((String)header, (char)this.spec.getColumnSeparator())).map(value -> {
                    String unquoted = value;
                    if (unquoted.charAt(0) == this.spec.getQuoteChar()) {
                        unquoted = unquoted.substring(1);
                    }
                    if (unquoted.charAt(unquoted.length() - 1) == this.spec.getQuoteChar()) {
                        unquoted = unquoted.substring(0, unquoted.length() - 1);
                    }
                    return unquoted;
                }).collect(Collectors.toList()));
            }
            return true;
        }
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = -4736870165235853919L;

        public Details(CSVPullSpec spec) {
            FileInputConfig csvFile = new FileInputConfig().showUpload(false).showRemove(false).showPreview(false).browseClass("btn btn-success").browseIcon("<i class=\"fas fa-folder-open\"></i> &nbsp;");
            String language = SyncopeConsoleSession.get().getLocale().getLanguage();
            if (!Locale.ENGLISH.getLanguage().equals(language)) {
                csvFile.withLocale(language);
            }
            final BootstrapFileInputField csvUpload = new BootstrapFileInputField("csvUpload", (IModel)new ListModel(new ArrayList()), csvFile);
            csvUpload.add(new Behavior[]{new AjaxFormSubmitBehavior("change"){
                private static final long serialVersionUID = 5538299138211283825L;

                protected void onSubmit(AjaxRequestTarget target) {
                    FileUpload uploadedFile = csvUpload.getFileUpload();
                    if (uploadedFile != null) {
                        if (CSVPullWizardBuilder.this.maxUploadSize != null && uploadedFile.getSize() > CSVPullWizardBuilder.this.maxUploadSize.bytes()) {
                            SyncopeConsoleSession.get().error((Serializable)((Object)Details.this.getString("tooLargeFile").replace("${maxUploadSizeB}", String.valueOf(CSVPullWizardBuilder.this.maxUploadSize.bytes())).replace("${maxUploadSizeMB}", String.valueOf(CSVPullWizardBuilder.this.maxUploadSize.bytes() / 1000000L))));
                            ((BasePage)CSVPullWizardBuilder.this.getPageReference().getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                        } else {
                            CSVPullWizardBuilder.this.csv.setObject((Serializable)uploadedFile.getBytes());
                        }
                    }
                }
            }});
            this.add(new Component[]{csvUpload.setRequired(true).setOutputMarkupId(true)});
            this.add(new Component[]{new CSVConfPanel("csvconf", (AbstractCSVSpec)spec)});
        }
    }

    public static enum LineSeparator {
        LF("\n"),
        CR("\r"),
        CRLF("\r\n");

        private final String repr;

        private LineSeparator(String repr) {
            this.repr = repr;
        }

        public String getRepr() {
            return this.repr;
        }

        public static LineSeparator byRepr(String repr) {
            for (LineSeparator value : LineSeparator.values()) {
                if (!value.getRepr().equals(repr)) continue;
                return value;
            }
            return null;
        }
    }
}

