/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.wizards.resources.AbstractResourceWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ConnCapabilitiesPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorConfPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorDetailsPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.ConnIdBundle;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.PropertyModel;

public class ConnectorWizardBuilder
extends AbstractResourceWizardBuilder<ConnInstanceTO> {
    private static final long serialVersionUID = -2025535531121434050L;
    protected final List<ConnIdBundle> bundles;
    protected final ConnectorRestClient connectorRestClient;

    public ConnectorWizardBuilder(ConnInstanceTO defaultItem, ConnectorRestClient connectorRestClient, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.bundles = connectorRestClient.getAllBundles().stream().filter(object -> object.getLocation().equals(defaultItem.getLocation())).collect(Collectors.toList());
        this.connectorRestClient = connectorRestClient;
    }

    protected WizardModel buildModelSteps(Serializable modelObject, WizardModel wizardModel) {
        ConnInstanceTO connInstanceTO = (ConnInstanceTO)ConnInstanceTO.class.cast(modelObject);
        wizardModel.add((IWizardStep)new ConnectorDetailsPanel(connInstanceTO, this.bundles));
        wizardModel.add((IWizardStep)new ConnectorConfPanel(connInstanceTO, this.bundles){
            private static final long serialVersionUID = -5886691077681158494L;

            @Override
            protected Pair<Boolean, String> check(AjaxRequestTarget target) {
                ConnInstanceTO connInstanceTO = (ConnInstanceTO)ConnInstanceTO.class.cast(this.modelObject);
                ConnIdBundle bundleTO = ConnectorWizardBuilder.getBundle(connInstanceTO, ConnectorWizardBuilder.this.bundles);
                connInstanceTO.setConnectorName(bundleTO.getConnectorName());
                connInstanceTO.setBundleName(bundleTO.getBundleName());
                connInstanceTO.setVersion(bundleTO.getVersion());
                return ConnectorWizardBuilder.this.connectorRestClient.check(connInstanceTO);
            }

            protected void onComponentTag(ComponentTag tag) {
                tag.append("class", (CharSequence)"scrollable-tab-content", " ");
            }
        });
        wizardModel.add((IWizardStep)new ConnCapabilitiesPanel((PropertyModel<List<ConnectorCapability>>)new PropertyModel((Object)connInstanceTO, "capabilities")));
        return wizardModel;
    }

    protected Serializable onApplyInternal(Serializable modelObject) {
        ConnInstanceTO connInstance;
        ConnInstanceTO connInstanceTO = (ConnInstanceTO)ConnInstanceTO.class.cast(modelObject);
        ConnIdBundle bundleTO = ConnectorWizardBuilder.getBundle(connInstanceTO, this.bundles);
        connInstanceTO.setConnectorName(bundleTO.getConnectorName());
        connInstanceTO.setBundleName(bundleTO.getBundleName());
        connInstanceTO.setVersion(bundleTO.getVersion());
        if (connInstanceTO.getPoolConf() != null && connInstanceTO.getPoolConf().getMaxIdle() == null && connInstanceTO.getPoolConf().getMaxObjects() == null && connInstanceTO.getPoolConf().getMaxWait() == null && connInstanceTO.getPoolConf().getMinEvictableIdleTimeMillis() == null && connInstanceTO.getPoolConf().getMinIdle() == null) {
            connInstanceTO.setPoolConf(null);
        }
        if (this.mode == AjaxWizard.Mode.CREATE) {
            connInstance = this.connectorRestClient.create(connInstanceTO);
        } else {
            this.connectorRestClient.update(connInstanceTO);
            connInstance = connInstanceTO;
        }
        return connInstance;
    }

    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        ConnInstanceTO connInstance = (ConnInstanceTO)ConnInstanceTO.class.cast(afterObject);
        return new AbstractResourceWizardBuilder.CreateEvent(connInstance.getKey(), connInstance.getDisplayName(), TopologyNode.Kind.CONNECTOR, (Serializable)((Object)URI.create(connInstance.getLocation()).toASCIIString()), target);
    }

    protected static ConnIdBundle getBundle(ConnInstanceTO connInstanceTO, List<ConnIdBundle> bundles) {
        return bundles.stream().filter(bundle -> bundle.getBundleName().equals(connInstanceTO.getBundleName()) && bundle.getConnectorName().equals(connInstanceTO.getConnectorName()) && bundle.getVersion().equals(connInstanceTO.getVersion())).findFirst().orElse(null);
    }
}

