/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springmodules.cache.CacheModel;
import org.springmodules.cache.util.TextMatcher;

public abstract class AbstractNameMatchCacheModelSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map cacheModels;

    protected final CacheModel getCacheModel(Method method) {
        String methodName = method.getName();
        CacheModel model = (CacheModel)this.cacheModels.get(methodName);
        if (model == null) {
            String bestNameMatch = null;
            Iterator i = this.cacheModels.keySet().iterator();
            while (i.hasNext()) {
                String mappedMethodName = (String)i.next();
                if (!this.isMatch(methodName, mappedMethodName) || bestNameMatch != null && bestNameMatch.length() > mappedMethodName.length()) continue;
                model = (CacheModel)this.cacheModels.get(mappedMethodName);
                bestNameMatch = mappedMethodName;
            }
        }
        return model;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return TextMatcher.isMatch(methodName, mappedName);
    }

    protected final void setCacheModels(Map newCacheModels) {
        this.cacheModels = newCacheModels;
    }
}

