/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.jcs;

import java.io.Serializable;
import java.util.Arrays;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.provider.AbstractFlushingModel;
import org.springmodules.util.Objects;

public final class JcsFlushingModel
extends AbstractFlushingModel {
    private static final long serialVersionUID = -1497138716500203888L;
    private CacheStruct[] cacheStructs;

    public JcsFlushingModel() {
    }

    public JcsFlushingModel(CacheStruct cacheStruct) {
        this();
        this.setCacheStruct(cacheStruct);
    }

    public JcsFlushingModel(String cacheName) {
        this(new CacheStruct(cacheName));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JcsFlushingModel)) {
            return false;
        }
        JcsFlushingModel flushingModel = (JcsFlushingModel)obj;
        return Arrays.equals(this.cacheStructs, flushingModel.cacheStructs);
    }

    public CacheStruct[] getCacheStructs() {
        return this.cacheStructs;
    }

    public int hashCode() {
        int multiplier = 31;
        int hash = 7;
        hash = multiplier * hash + Objects.nullSafeHashCode(this.cacheStructs);
        return hash;
    }

    public void setCacheStruct(CacheStruct cacheStruct) {
        this.setCacheStructs(new CacheStruct[]{cacheStruct});
    }

    public void setCacheStructs(CacheStruct[] newCacheStructs) {
        this.cacheStructs = newCacheStructs;
    }

    public String toString() {
        StringBuffer buffer = Objects.identityToString(this);
        buffer.append("[cacheStructs=" + Objects.nullSafeToString(this.cacheStructs) + ", ");
        buffer.append("flushBeforeMethodExecution=" + this.flushBeforeMethodExecution() + "]");
        return buffer.toString();
    }

    public static class CacheStruct
    implements Serializable {
        private static final long serialVersionUID = -2168328935167938683L;
        private String cacheName;
        private String[] groups;

        public CacheStruct() {
        }

        public CacheStruct(String cacheName) {
            this();
            this.setCacheName(cacheName);
        }

        public CacheStruct(String cacheName, String csvGroups) {
            this(cacheName);
            this.setGroups(csvGroups);
        }

        public CacheStruct(String cacheName, String[] groups) {
            this(cacheName);
            this.setGroups(groups);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheStruct)) {
                return false;
            }
            CacheStruct cacheStruct = (CacheStruct)obj;
            if (!ObjectUtils.nullSafeEquals((Object)this.cacheName, (Object)cacheStruct.cacheName)) {
                return false;
            }
            return Arrays.equals(this.groups, cacheStruct.groups);
        }

        public String getCacheName() {
            return this.cacheName;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public int hashCode() {
            int multiplier = 31;
            int hash = 7;
            hash = multiplier * hash + Objects.nullSafeHashCode(this.cacheName);
            hash = multiplier * hash + Objects.nullSafeHashCode(this.groups);
            return hash;
        }

        public void setCacheName(String newCacheName) {
            this.cacheName = newCacheName;
        }

        public void setGroups(String csvGroups) {
            String[] newGroups = null;
            if (StringUtils.hasText((String)csvGroups)) {
                newGroups = StringUtils.commaDelimitedListToStringArray((String)csvGroups);
            }
            this.setGroups(newGroups);
        }

        public void setGroups(String[] newGroups) {
            this.groups = newGroups;
        }

        public String toString() {
            StringBuffer buffer = Objects.identityToString(this);
            buffer.append("[cacheName=" + StringUtils.quote((String)this.cacheName) + ", ");
            buffer.append("groups=" + Objects.nullSafeToString(this.groups) + "]");
            return buffer.toString();
        }
    }
}

