/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ValidateCaptchaAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateCaptchaAction.class);
    private final CaptchaValidator captchaValidator;
    private final CaptchaActivationStrategy captchaActivationStrategy;

    protected Event doExecute(RequestContext requestContext) {
        if (this.captchaActivationStrategy.shouldActivate(requestContext, this.captchaValidator.getRecaptchaProperties()).isEmpty()) {
            LOGGER.debug("Recaptcha is not set to activate for the current request");
            return null;
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String userAgent = WebUtils.getHttpServletRequestUserAgentFromRequestContext();
        String gRecaptchaResponse = this.captchaValidator.getRecaptchaResponse(request);
        if (StringUtils.isBlank((CharSequence)gRecaptchaResponse)) {
            LOGGER.warn("Recaptcha response/token is missing from the request");
            return this.getError(requestContext);
        }
        boolean result = this.captchaValidator.validate(gRecaptchaResponse, userAgent);
        if (result) {
            LOGGER.debug("Recaptcha has successfully validated the request");
            return null;
        }
        return this.getError(requestContext);
    }

    private Event getError(RequestContext requestContext) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)"captchaError", (String)"captchaError");
        return this.getEventFactorySupport().event((Object)this, "captchaError");
    }

    @Generated
    public ValidateCaptchaAction(CaptchaValidator captchaValidator, CaptchaActivationStrategy captchaActivationStrategy) {
        this.captchaValidator = captchaValidator;
        this.captchaActivationStrategy = captchaActivationStrategy;
    }
}

