/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.SequencedElement;
import org.ehcache.clustered.common.internal.util.ChainBuilder;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructArrayEncoder;
import org.terracotta.runnel.encoding.StructEncoder;

public final class ChainCodec {
    private static final Struct ELEMENT_STRUCT = StructBuilder.newStructBuilder().int64("sequence", 10).byteBuffer("payload", 20).build();
    public static final Struct CHAIN_STRUCT = StructBuilder.newStructBuilder().structs("elements", 10, ELEMENT_STRUCT).build();

    private ChainCodec() {
    }

    public static byte[] encode(Chain chain) {
        StructEncoder encoder = CHAIN_STRUCT.encoder();
        ChainCodec.encode(encoder, chain);
        ByteBuffer byteBuffer = encoder.encode();
        return byteBuffer.array();
    }

    public static void encode(StructEncoder<?> encoder, Chain chain) {
        StructArrayEncoder elementsEncoder = encoder.structs("elements");
        for (Element element : chain) {
            StructEncoder elementEncoder = elementsEncoder.add();
            if (element instanceof SequencedElement) {
                elementEncoder.int64("sequence", ((SequencedElement)element).getSequenceNumber());
            }
            elementEncoder.byteBuffer("payload", element.getPayload());
            elementEncoder.end();
        }
        elementsEncoder.end();
    }

    public static Chain decode(byte[] payload) {
        StructDecoder decoder = CHAIN_STRUCT.decoder(ByteBuffer.wrap(payload));
        return ChainCodec.decode(decoder);
    }

    public static Chain decode(StructDecoder<?> decoder) {
        StructArrayDecoder elementsDecoder = decoder.structs("elements");
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < elementsDecoder.length(); ++i) {
            StructDecoder elementDecoder = elementsDecoder.next();
            final Long sequence = elementDecoder.int64("sequence");
            final ByteBuffer byteBuffer = elementDecoder.byteBuffer("payload");
            elementDecoder.end();
            if (sequence == null) {
                elements.add(byteBuffer::asReadOnlyBuffer);
                continue;
            }
            elements.add(new SequencedElement(){

                @Override
                public long getSequenceNumber() {
                    return sequence;
                }

                @Override
                public ByteBuffer getPayload() {
                    return byteBuffer.asReadOnlyBuffer();
                }

                public String toString() {
                    return "SequencedElement{sequence=" + sequence + " size=" + byteBuffer.capacity() + "}";
                }
            });
        }
        elementsDecoder.end();
        return ChainBuilder.chainFromList(elements);
    }
}

