/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrRepoTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AttrRepo;
import org.apache.syncope.core.provisioning.api.data.AttrRepoDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttrRepoDataBinderImpl
implements AttrRepoDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AttrRepoDataBinder.class);
    protected final EntityFactory entityFactory;

    public AttrRepoDataBinderImpl(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    protected void populateItems(AttrRepoTO attrRepoTO, AttrRepo attrRepo) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        attrRepoTO.getItems().forEach(itemTO -> {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)Item.class.getSimpleName());
                invalidMapping.getElements().add("Null " + Item.class.getSimpleName());
            } else if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
            } else {
                if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
                    SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                    invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                    scce.addException(invalidMandatoryCondition);
                }
                Item item = new Item();
                item.setIntAttrName(itemTO.getIntAttrName());
                item.setExtAttrName(itemTO.getExtAttrName());
                item.setMandatoryCondition(itemTO.getMandatoryCondition());
                item.setConnObjectKey(itemTO.isConnObjectKey());
                item.setPassword(itemTO.isPassword());
                item.setPropagationJEXLTransformer(itemTO.getPropagationJEXLTransformer());
                item.setPullJEXLTransformer(itemTO.getPullJEXLTransformer());
                attrRepo.getItems().add(item);
            }
        });
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public AttrRepo create(AttrRepoTO attrRepoTO) {
        AttrRepo attrRepo = (AttrRepo)this.entityFactory.newEntity(AttrRepo.class);
        attrRepo.setKey(attrRepoTO.getKey());
        return this.update(attrRepo, attrRepoTO);
    }

    public AttrRepo update(AttrRepo attrRepo, AttrRepoTO attrRepoTO) {
        attrRepo.setDescription(attrRepoTO.getDescription());
        attrRepo.setState(attrRepoTO.getState());
        attrRepo.setOrder(attrRepoTO.getOrder());
        attrRepo.setConf(attrRepoTO.getConf());
        attrRepo.getItems().clear();
        this.populateItems(attrRepoTO, attrRepo);
        return attrRepo;
    }

    protected void populateItems(AttrRepo attrRepo, AttrRepoTO attrRepoTO) {
        attrRepo.getItems().forEach(item -> {
            Item itemTO = new Item();
            itemTO.setIntAttrName(item.getIntAttrName());
            itemTO.setExtAttrName(item.getExtAttrName());
            itemTO.setMandatoryCondition(item.getMandatoryCondition());
            itemTO.setConnObjectKey(item.isConnObjectKey());
            itemTO.setPassword(item.isPassword());
            itemTO.setPropagationJEXLTransformer(item.getPropagationJEXLTransformer());
            itemTO.setPullJEXLTransformer(item.getPullJEXLTransformer());
            itemTO.setPurpose(MappingPurpose.NONE);
            attrRepoTO.getItems().add(itemTO);
        });
    }

    public AttrRepoTO getAttrRepoTO(AttrRepo attrRepo) {
        AttrRepoTO attrRepoTO = new AttrRepoTO();
        attrRepoTO.setKey(attrRepo.getKey());
        attrRepoTO.setDescription(attrRepo.getDescription());
        attrRepoTO.setState(attrRepo.getState());
        attrRepoTO.setOrder(attrRepo.getOrder());
        attrRepoTO.setConf(attrRepo.getConf());
        this.populateItems(attrRepo, attrRepoTO);
        return attrRepoTO;
    }
}

