/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.principal.resolvers.InternalGroovyScriptDao;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributeScriptDao;
import org.apereo.services.persondir.support.GroovyPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.PersonDirectory)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfiguration
public class CasPersonDirectoryGroovyConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryGroovyConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.groovy[0].location").exists();

    @Configuration(value="GroovyAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class GroovyAttributeRepositoryPlanConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"groovyPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer groovyPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="groovyAttributeRepositories") BeanContainer<IPersonAttributeDao> groovyAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = groovyAttributeRepositories.toList().stream().filter(repo -> (Boolean)repo.getTags().get(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName())).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="GroovyAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class GroovyAttributeRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"groovyAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<IPersonAttributeDao> groovyAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ArrayList list = new ArrayList();
                casProperties.getAuthn().getAttributeRepository().getGroovy().stream().filter(groovy -> groovy.getLocation() != null).forEach(groovy -> {
                    GroovyPersonAttributeDao dao = new GroovyPersonAttributeDao((IPersonAttributeScriptDao)new InternalGroovyScriptDao((ApplicationContext)applicationContext, casProperties, groovy));
                    dao.setCaseInsensitiveUsername(groovy.isCaseInsensitive());
                    dao.setOrder(groovy.getOrder());
                    dao.setEnabled(groovy.getState() != AttributeRepositoryStates.DISABLED);
                    dao.putTag(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName(), (Object)(groovy.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
                    FunctionUtils.doIfNotNull((Object)groovy.getId(), xva$0 -> dao.setId(new String[]{xva$0}));
                    LOGGER.debug("Configured Groovy attribute sources from [{}]", (Object)groovy.getLocation());
                    list.add(dao);
                });
                return BeanContainer.of(list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

